/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodFallbackTypeConverter
implements TypeConverter {
    private final Method method;
    private final boolean useExchange;
    private final TypeConverterRegistry registry;

    public StaticMethodFallbackTypeConverter(Method method, TypeConverterRegistry registry) {
        this.method = method;
        this.useExchange = method.getParameterTypes().length == 4;
        this.registry = registry;
    }

    public String toString() {
        return "StaticMethodFallbackTypeConverter: " + this.method;
    }

    @Override
    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        return (T)(this.useExchange ? ObjectHelper.invokeMethod(this.method, null, type, exchange, value, this.registry) : ObjectHelper.invokeMethod(this.method, null, type, value, this.registry));
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) {
        return this.convertTo(type, null, value);
    }
}

