/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.gbrowser.index;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.gbrowser.index.GetGeneIndexData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class GeneIndexActions {
    private static HashMap<String, GeneIndexActions> instances = new HashMap();
    private PreparedStatement insertGeneStatement;
    private PreparedStatement selectStatement;

    protected GeneIndexActions(ChunkDataSource dataSource, String id) throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:" + id, "", "");
        this.initialise(conn);
        if (dataSource != null) {
            GetGeneIndexData data = new GetGeneIndexData(dataSource);
            this.updateTable(data.read());
        }
    }

    private void initialise(Connection conn) throws SQLException {
        PreparedStatement createTableStatements = conn.prepareStatement("DROP TABLE gene IF EXISTS;CREATE TABLE gene (ID INT PRIMARY KEY AUTO_INCREMENT, chromosome VARCHAR(255),bp_start INT, bp_end INT, name VARCHAR(255));DROP INDEX gene_name_index IF EXISTS;CREATE INDEX gene_name_index ON gene(name);");
        createTableStatements.execute();
        this.insertGeneStatement = conn.prepareStatement("INSERT INTO gene VALUES (NULL, ?, ?, ?, ?);");
        this.selectStatement = conn.prepareStatement("SELECT chromosome, bp_start, bp_end FROM gene WHERE name = ?");
    }

    public static GeneIndexActions getInstance(AnnotationManager.Genome genome, ChunkDataSource dataSource) throws ClassNotFoundException, SQLException {
        String genomeString = genome.toString();
        if (!instances.containsKey(genomeString)) {
            instances.put(genomeString, new GeneIndexActions(dataSource, genomeString.replace(" ", "")));
        }
        return instances.get(genomeString);
    }

    private void updateTable(List<RegionContent> indexList) throws SQLException {
        for (RegionContent id : indexList) {
            String chromosome = id.values.get((Object)ColumnType.CHROMOSOME).toString();
            String bpStart = id.values.get((Object)ColumnType.BP_START).toString();
            String bpEnd = id.values.get((Object)ColumnType.BP_END).toString();
            String name = id.values.get((Object)ColumnType.DESCRIPTION).toString();
            this.insertGene(chromosome, bpStart, bpEnd, name);
        }
    }

    protected void insertGene(String chromosome, String bpStart, String bpEnd, String name) throws SQLException {
        this.insertGeneStatement.setString(1, chromosome);
        this.insertGeneStatement.setString(2, bpStart);
        this.insertGeneStatement.setString(3, bpEnd);
        this.insertGeneStatement.setString(4, name.toUpperCase());
        this.insertGeneStatement.executeUpdate();
    }

    public BpCoordRegion getLocation(String name) throws SQLException {
        this.selectStatement.setString(1, name.toUpperCase());
        ResultSet rs = this.selectStatement.executeQuery();
        if (rs.next()) {
            return new BpCoordRegion(rs.getLong(2), rs.getLong(3), new Chromosome(rs.getString(1)));
        }
        return null;
    }

    public static boolean checkIfNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(name);
                return true;
            }
            catch (NumberFormatException e1) {
                return false;
            }
        }
    }
}

