/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker.encryption;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class TestServer {
    public static void main(String[] args) throws Exception {
        Server jettyInstance = new Server();
        jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setServer(jettyInstance);
        connector.setPort(9080);
        SslSocketConnector sslConnector = new SslSocketConnector();
        sslConnector.setServer(jettyInstance);
        sslConnector.setPort(9443);
        sslConnector.setKeystore("keystore.ks");
        sslConnector.setKeyPassword("microarray");
        jettyInstance.setConnectors(new Connector[]{connector, sslConnector});
        Context root = new Context((HandlerContainer)jettyInstance, "/", false, false);
        root.setResourceBase("/tmp/test-root");
        root.addServlet(new ServletHolder((Servlet)new UploadServlet()), "/*");
        jettyInstance.start();
    }

    public static class UploadServlet
    extends DefaultServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            System.out.println("GET request for " + request.getRequestURL());
            super.doGet(request, response);
        }

        protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            boolean success;
            System.out.println("PUT request for " + request.getRequestURL());
            File file = new File(this.getServletContext().getRealPath(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())));
            if (file.exists() && !(success = file.delete())) {
                response.sendError(500);
                return;
            }
            FileOutputStream out = new FileOutputStream(file);
            try {
                IO.copy((InputStream)request.getInputStream(), (OutputStream)out);
            }
            catch (IOException e) {
                Log.warn((String)"EXCEPTION ", (Throwable)e);
                out.close();
                throw e;
            }
            response.setStatus(204);
        }
    }
}

