/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RepeatMaskerTrack
extends Track {
    private long maxBpLength;
    private LinkedList<Long> collector = new LinkedList();
    private final Color UPPER_COLOR = Color.white;
    private final Color LOWER_COLOR = new Color(192, 192, 192);
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();

    public RepeatMaskerTrack(View view, DataSource file, Class<? extends AreaRequestHandler> handler, long maxBpLength) {
        super(view, file, handler);
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.collector.clear();
        Boolean firstCase = null;
        Boolean lastChar = null;
        Long lastCharCoord = null;
        if (this.reads != null) {
            Iterator bpLocations;
            Iterator<RegionContent> iter = this.reads.iterator();
            Chromosome lastChromosome = null;
            RegionContent read = null;
            while (iter.hasNext()) {
                read = iter.next();
                if (!read.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                BpCoord startBp = read.region.start;
                BpCoord endBp = read.region.end;
                lastChromosome = read.region.start.chr;
                String seq = (String)read.values.get((Object)ColumnType.SEQUENCE);
                seq = seq != null ? seq.trim() : "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".substring(0, (int)(endBp.minus(startBp) + 1L));
                int seqLength = (int)(endBp.minus(startBp) - 0L);
                boolean lastCase = Character.isUpperCase(seq.charAt(0));
                if (firstCase == null) {
                    firstCase = lastCase;
                }
                if (lastChar != null && lastChar != lastCase) {
                    this.collector.add(lastCharCoord);
                }
                int j = 0;
                Long i = read.region.start.bp + 1L;
                while (i <= read.region.start.bp + (long)seqLength + 1L) {
                    if (Character.isUpperCase(seq.charAt(j)) != lastCase) {
                        lastCase = Character.isUpperCase(seq.charAt(j));
                        this.collector.add(i - 1L);
                    }
                    ++j;
                    Long l = i;
                    Long l2 = i = Long.valueOf(i + 1L);
                }
                lastChar = Character.isUpperCase(seq.charAt(seq.length() - 1));
                lastCharCoord = read.region.start.bp + (long)seqLength + 1L;
            }
            if (read != null) {
                this.collector.add(read.region.end.bp);
            }
            if ((bpLocations = this.collector.iterator()).hasNext() && this.reads.iterator().hasNext()) {
                Color c;
                Long lastBpLocation = this.reads.iterator().next().region.start.bp;
                Color color = c = firstCase != false ? this.UPPER_COLOR : this.LOWER_COLOR;
                while (bpLocations.hasNext()) {
                    Long currentBpLocation = (Long)bpLocations.next();
                    long startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, lastChromosome)).intValue();
                    long endX = this.getView().bpToTrack(new BpCoord(currentBpLocation, lastChromosome)).intValue();
                    if (c != this.UPPER_COLOR) {
                        drawables.add(new RectDrawable(new Rectangle((int)startX, 0, (int)(endX - startX), this.getHeight()), c, c));
                    }
                    lastBpLocation = currentBpLocation;
                    c = c == this.UPPER_COLOR ? this.LOWER_COLOR : this.UPPER_COLOR;
                }
            }
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        this.reads.addAll(areaResult.getContents());
        this.getView().redraw();
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.SEQUENCE)));
        return datas;
    }

    @Override
    public String getName() {
        return "RepeatMaskerTrack";
    }
}

