/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PeakTrack
extends Track {
    private static final int MIN_VISIBLE_PEAK_SIZE = 5;
    private static final int PEAK_SYMBOL_HEIGHT = 10;
    private Collection<RegionContent> peaks = new TreeSet<RegionContent>();
    private long maxBpLength;
    private long minBpLength;
    private Color color;

    public PeakTrack(View view, DataSource file, Class<? extends AreaRequestHandler> handler, Color color, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.peaks != null) {
            Iterator<RegionContent> iter = this.peaks.iterator();
            while (iter.hasNext()) {
                RegionContent peak = iter.next();
                if (!peak.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                this.createDrawable(peak.region.start, peak.region.end, 10, this.color, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c, Collection<Drawable> drawables) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        if (rect.width < 5) {
            rect.width = 5;
        }
        rect.y = (int)(this.getView().getTrackHeight() / 2.0f);
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, c.darker()));
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult.getStatus().concise == this.isConcised()) {
            this.peaks.addAll(areaResult.getContents());
            this.getView().redraw();
        }
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.CHROMOSOME, ColumnType.BP_START, ColumnType.BP_END)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }
}

