/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GeneTrack
extends Track {
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    private List<Integer> occupiedSpace = new ArrayList<Integer>();
    private long maxBpLength;
    private long minBpLength;
    private Color color;

    public GeneTrack(View view, ChunkDataSource file, Class<? extends AreaRequestHandler> handler, Color color, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.reads != null) {
            Iterator<RegionContent> iter = this.reads.iterator();
            while (iter.hasNext()) {
                RegionContent read = iter.next();
                if (!read.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                String name = (String)read.values.get((Object)ColumnType.DESCRIPTION);
                this.createDrawable(read.region.start, read.region.end, 10, this.color, name, drawables);
            }
        }
        return drawables;
    }

    private void createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c, String name, Collection<Drawable> drawables) {
        int i;
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
        }
        int end = rect.x + rect.width;
        if (this.occupiedSpace.size() > i) {
            this.occupiedSpace.set(i, end);
        } else {
            this.occupiedSpace.add(end);
        }
        rect.y = (i + 1) * (height + 2);
        rect.height = height;
        drawables.add(new RectDrawable(rect, c, null));
        if (this.isNameVisible(rect)) {
            name = name.replaceAll("\"", "");
            this.drawTextAboveRectangle(name, drawables, rect, 10);
        }
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (areaResult.getStatus().concise != this.isConcised() || content.values.get((Object)ColumnType.STRAND) != this.getStrand()) continue;
            this.reads.add(content);
            this.getView().redraw();
        }
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.STRAND, ColumnType.DESCRIPTION, ColumnType.VALUE)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }
}

