/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.BaseStorage;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeqBlockTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CoverageAndSNPTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private Color forwardColor;
    private boolean highlightSNP = false;
    private BaseStorage theBaseCacheThang = new BaseStorage();
    private DataSource refFile;
    private Collection<RegionContent> refReads = new TreeSet<RegionContent>();
    private ReadpartDataProvider readpartProvider;

    public CoverageAndSNPTrack(View view, DataSource file, ReadpartDataProvider readpartProvider, Class<? extends AreaRequestHandler> handler, DataSource refFile, Class<? extends AreaRequestHandler> refHandler, Color forwardColor, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.forwardColor = forwardColor;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.readpartProvider = readpartProvider;
        this.setStrand(Strand.BOTH);
        this.refFile = refFile;
        view.getQueueManager().createQueue(refFile, refHandler);
    }

    @Override
    public void initializeListener() {
        super.initializeListener();
        if (this.file != null) {
            this.view.getQueueManager().addResultListener(this.refFile, this);
        }
    }

    private Collection<Drawable> getDrawableReads(Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Chromosome chr = this.getView().getBpRegion().start.chr;
        char[] refSeq = SeqBlockTrack.getReferenceArray(this.refReads, this.view, this.strand);
        this.theBaseCacheThang.getNucleotideCounts(this.readpartProvider.getReadparts(this.getStrand()), this.view, refSeq);
        int bpWidth = (int)((long)this.getView().getWidth() / this.getView().getBpRegion().getLength());
        int bottomlineY = 0;
        Iterator<BaseStorage.Base> bases = this.theBaseCacheThang.iterator();
        if (bases.hasNext()) {
            BaseStorage.Base previousBase = bases.next();
            int startX = this.getView().bpToTrack(new BpCoord(previousBase.getBpLocation(), chr));
            long startY = previousBase.getCoverage();
            drawables.add(new LineDrawable(0, bottomlineY, startX - bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(startX - bpWidth, bottomlineY, startX, (int)((long)bottomlineY + startY), color));
            this.drawSNPBar(drawables, bpWidth, bottomlineY, previousBase, startX);
            while (bases.hasNext()) {
                BaseStorage.Base currentBase = bases.next();
                startX = this.getView().bpToTrack(new BpCoord(previousBase.getBpLocation(), chr));
                startY = previousBase.getCoverage();
                int endX = this.getView().bpToTrack(new BpCoord(currentBase.getBpLocation(), chr));
                long endY = currentBase.getCoverage();
                this.drawSNPBar(drawables, bpWidth, bottomlineY, currentBase, endX);
                if (currentBase.getBpLocation() - previousBase.getBpLocation() == 1L) {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), endX, (int)((long)bottomlineY + endY), color));
                } else {
                    drawables.add(new LineDrawable(startX, (int)((long)bottomlineY + startY), startX + bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(startX + bpWidth, bottomlineY, endX - bpWidth, bottomlineY, color));
                    drawables.add(new LineDrawable(endX - bpWidth, bottomlineY, endX, (int)((long)bottomlineY + endY), color));
                }
                previousBase = currentBase;
            }
            int endX = this.getView().bpToTrack(new BpCoord(previousBase.getBpLocation(), chr));
            long endY = previousBase.getCoverage();
            drawables.add(new LineDrawable(endX, (int)((long)bottomlineY + endY), endX + bpWidth, bottomlineY, color));
            drawables.add(new LineDrawable(endX + bpWidth, bottomlineY, this.getView().getWidth(), bottomlineY, color));
        }
        return drawables;
    }

    private void drawSNPBar(Collection<Drawable> drawables, int bpWidth, int bottomlineY, BaseStorage.Base currentBase, int endX) {
        if (this.highlightSNP && currentBase.hasSignificantSNPs()) {
            int y = bottomlineY;
            for (BaseStorage.Nucleotide nt : BaseStorage.Nucleotide.values()) {
                int increment = currentBase.getSNPCounts()[nt.ordinal()];
                if (increment <= 0) continue;
                Color c = SeqBlockTrack.charColors[nt.ordinal()];
                drawables.add(new RectDrawable(endX, y, bpWidth, increment, c, c));
                y += increment;
            }
        }
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        drawables.addAll(this.getDrawableReads(this.forwardColor));
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult.getStatus().file == this.refFile) {
            this.refReads.addAll(areaResult.getContents());
        }
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 100;
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.SEQUENCE, ColumnType.STRAND, ColumnType.QUALITY, ColumnType.CIGAR)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    @Override
    public String getName() {
        return "ProfileSNPTrack";
    }

    public void enableSNPHighlight() {
        this.highlightSNP = true;
    }

    public void disableSNPHighlight() {
        this.highlightSNP = false;
    }
}

