/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;

public class BpCoordDouble
implements Comparable<BpCoordDouble> {
    public Double bp;
    public Chromosome chr;

    public BpCoordDouble(Double bp, Chromosome chr) {
        this.bp = bp;
        this.chr = chr;
    }

    public BpCoordDouble(BpCoord coord) {
        this.bp = (double)coord.bp;
        this.chr = coord.chr;
    }

    @Override
    public int compareTo(BpCoordDouble o) {
        int chrComparison = this.chr.compareTo(o.chr);
        if (chrComparison != 0) {
            return chrComparison;
        }
        return this.bp.compareTo(o.bp);
    }

    public boolean equals(Object o) {
        if (o instanceof BpCoordDouble) {
            BpCoordDouble other = (BpCoordDouble)o;
            return this.chr.equals(other.chr) && this.bp.equals(other.bp);
        }
        return false;
    }

    public int hashCode() {
        return this.bp.hashCode();
    }

    public double minus(BpCoordDouble o) {
        if (this.chr.equals(o.chr)) {
            return this.bp - o.bp;
        }
        return Double.NaN;
    }

    public double plus(BpCoordDouble o) {
        if (this.chr.equals(o.chr)) {
            return this.bp + o.bp;
        }
        return Double.NaN;
    }

    public BpCoordDouble move(double increment) {
        return new BpCoordDouble(this.bp + increment, this.chr);
    }

    public String toString() {
        return "Bp: " + this.bp + ", Chr: " + this.chr;
    }

    public BpCoordDouble max(BpCoordDouble other) {
        return this.compareTo(other) < 0 ? other : this;
    }

    public BpCoordDouble min(BpCoordDouble other) {
        return this.compareTo(other) > 0 ? other : this;
    }

    public BpCoord asBpCoord() {
        return new BpCoord((long)this.bp.doubleValue(), this.chr);
    }
}

