/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class TsvParser
extends FileParser {
    private FileDefinition fileDef;

    public TsvParser(FileDefinition fileDef) {
        this.fileDef = fileDef;
    }

    public String[] getFirstRow(Chunk chunk) {
        return chunk.getContent().substring(0, chunk.getContent().indexOf("\n")).split("\t");
    }

    public String[] getLastRow(Chunk chunk) {
        int lineStartIndex = chunk.getContent().lastIndexOf("\n", chunk.getContent().length() - 2);
        if (lineStartIndex < 0) {
            lineStartIndex = 0;
        }
        return chunk.getContent().substring(lineStartIndex + 1, chunk.getContent().length()).split("\t");
    }

    @Override
    public BpCoordRegion getBpRegion(Chunk chunk) {
        Long end;
        String[] firstRow = this.getFirstRow(chunk);
        String[] lastRow = this.getLastRow(chunk);
        Long start = (Long)this.get(firstRow, ColumnType.BP_START);
        try {
            end = (Long)this.get(lastRow, ColumnType.BP_END);
        }
        catch (RuntimeException e) {
            end = (Long)this.get(lastRow, ColumnType.BP_START) + (long)((String)this.get(lastRow, ColumnType.SEQUENCE)).length();
        }
        Chromosome startChr = (Chromosome)this.get(firstRow, ColumnType.CHROMOSOME);
        Chromosome endChr = (Chromosome)this.get(lastRow, ColumnType.CHROMOSOME);
        return new BpCoordRegion(start, startChr, end, endChr);
    }

    public Object get(String[] cols, ColumnType col) {
        try {
            if (cols.length <= 1) {
                return null;
            }
            String string = cols[this.getFileDefinition().indexOf(col)].trim();
            ColumnDefinition fieldDef = this.getFileDefinition().getFieldDef(col);
            if (col == ColumnType.STRAND) {
                return string.equals("-1") || string.equalsIgnoreCase("r") || string.equals("-") ? Strand.REVERSED : Strand.FORWARD;
            }
            if (col == ColumnType.CHROMOSOME) {
                return new Chromosome(string);
            }
            if (fieldDef.type == Type.STRING) {
                return string;
            }
            if (fieldDef.type == Type.FLOAT) {
                return new Float(string);
            }
            if (fieldDef.type == Type.LONG) {
                if (string.length() > 0) {
                    return new Long(string);
                }
                return Long.MIN_VALUE;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("error parsing columns: " + Arrays.toString(cols) + " (looking for: " + (Object)((Object)col) + ")", e);
        }
    }

    @Override
    public List<RegionContent> getAll(Chunk chunk, Collection<ColumnType> requestedContents) {
        LinkedList<RegionContent> rows = new LinkedList<RegionContent>();
        for (String row : chunk.getContent().split("\n")) {
            String[] cols = row.split("\t");
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            for (ColumnType requestedContent : requestedContents) {
                values.put(requestedContent, this.get(cols, requestedContent));
            }
            Long start = (Long)this.get(cols, ColumnType.BP_START);
            Long end = (Long)this.get(cols, ColumnType.BP_END);
            Chromosome chr = (Chromosome)this.get(cols, ColumnType.CHROMOSOME);
            rows.add(new RegionContent(new BpCoordRegion(start, end, chr), values));
        }
        return rows;
    }

    public void setFileDefinition(FileDefinition fileDef) {
        this.fileDef = fileDef;
    }

    public FileDefinition getFileDefinition() {
        return this.fileDef;
    }

    @Override
    public long getDefaulChunkLength() {
        return 2048L;
    }

    public long getHeaderLength(File file) throws IOException {
        return 0L;
    }
}

