/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ElandParser
extends TsvParser {
    public ElandParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)Arrays.asList(new ColumnDefinition(ColumnType.ID, Type.STRING), new ColumnDefinition(ColumnType.SEQUENCE, Type.STRING), new ColumnDefinition(ColumnType.QUALITY, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.SKIP, Type.STRING), new ColumnDefinition(ColumnType.CHROMOSOME, Type.STRING), new ColumnDefinition(ColumnType.BP_START, Type.LONG), new ColumnDefinition(ColumnType.STRAND, Type.STRING))));
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        long totalF = 0L;
        long totalR = 0L;
        long readLength = ((String)this.get(this.getFirstRow(chunk), ColumnType.SEQUENCE)).length();
        for (RegionContent rc : this.getAll(chunk, Arrays.asList(ColumnType.STRAND))) {
            if ((Strand)((Object)rc.values.get((Object)ColumnType.STRAND)) == Strand.FORWARD) {
                totalF += readLength;
                continue;
            }
            totalR += readLength;
        }
        RegionContent[] result = new RegionContent[]{new RegionContent(this.getBpRegion(chunk), Float.valueOf((float)totalF / (float)this.getBpRegion(chunk).getLength().longValue())), new RegionContent(this.getBpRegion(chunk), Float.valueOf((float)totalR / (float)this.getBpRegion(chunk).getLength().longValue()))};
        result[0].values.put(ColumnType.STRAND, (Object)Strand.FORWARD);
        result[1].values.put(ColumnType.STRAND, (Object)Strand.REVERSED);
        return result;
    }

    @Override
    public List<RegionContent> getAll(Chunk chunk, Collection<ColumnType> requestedContents) {
        LinkedList<RegionContent> rows = new LinkedList<RegionContent>();
        for (String row : chunk.getContent().split("\n")) {
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            String[] cols = row.split("\t");
            for (ColumnType requestedContent : requestedContents) {
                values.put(requestedContent, this.get(cols, requestedContent));
            }
            Long start = (Long)this.get(cols, ColumnType.BP_START);
            Chromosome chr = (Chromosome)this.get(cols, ColumnType.CHROMOSOME);
            long readLength = ((String)this.get(cols, ColumnType.SEQUENCE)).length();
            rows.add(new RegionContent(new BpCoordRegion(start, start + readLength, chr), values));
        }
        return rows;
    }

    @Override
    public Object get(String[] cols, ColumnType col) {
        Object obj = super.get(cols, col);
        if (col == ColumnType.CHROMOSOME) {
            return new Chromosome(((Chromosome)obj).toString().replace(".fa", ""));
        }
        return obj;
    }

    @Override
    public String getName() {
        return "eland";
    }
}

