/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Arrays;

public abstract class AnnotationTsvParser
extends TsvParser {
    public AnnotationTsvParser(FileDefinition fileDef) {
        super(fileDef);
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        Chromosome chr;
        Long end;
        long totalF = 0L;
        long totalR = 0L;
        Long start = (Long)this.get(this.getFirstRow(chunk), ColumnType.BP_START);
        Long readLength = new BpCoordRegion(start, end = (Long)this.get(this.getLastRow(chunk), ColumnType.BP_START), chr = (Chromosome)this.get(this.getFirstRow(chunk), ColumnType.CHROMOSOME)).getLength();
        if (readLength != null) {
            for (RegionContent rc : this.getAll(chunk, Arrays.asList(ColumnType.STRAND))) {
                if ((Strand)((Object)rc.values.get((Object)ColumnType.STRAND)) == Strand.FORWARD) {
                    totalF += readLength.longValue();
                    continue;
                }
                totalR += readLength.longValue();
            }
            Long regionLength = this.getBpRegion(chunk).getLength();
            if (regionLength != null) {
                RegionContent[] result = new RegionContent[]{new RegionContent(this.getBpRegion(chunk), Float.valueOf((float)totalF / (float)regionLength.longValue())), new RegionContent(this.getBpRegion(chunk), Float.valueOf((float)totalR / (float)regionLength.longValue()))};
                result[0].values.put(ColumnType.STRAND, (Object)Strand.FORWARD);
                result[1].values.put(ColumnType.STRAND, (Object)Strand.REVERSED);
                return result;
            }
        }
        return new RegionContent[0];
    }
}

