/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class SAMFileFetcherThread
extends Thread {
    private final int SAMPLE_SIZE_BP = 100;
    private static final int RESULT_CHUNK_SIZE = 500;
    private BlockingQueue<SAMFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<SAMFileResult> fileResultQueue;
    private SAMDataSource dataSource;
    private SAMHandlerThread areaRequestThread;
    private BpCoordRegion previousRequestedRegion;

    public SAMFileFetcherThread(BlockingQueue<SAMFileRequest> fileRequestQueue, ConcurrentLinkedQueue<SAMFileResult> fileResultQueue, SAMHandlerThread areaRequestThread, SAMDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.dataSource = dataSource;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.processFileRequest(this.fileRequestQueue.take());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void processFileRequest(SAMFileRequest fileRequest) throws IOException {
        if (fileRequest.areaRequest.status.concise) {
            this.sampleToGetConcisedRegion(fileRequest);
        } else {
            AreaRequest request = fileRequest.areaRequest;
            if (this.previousRequestedRegion != null && request.intersects(this.previousRequestedRegion)) {
                BpCoordRegion overlap = request.intersect(this.previousRequestedRegion);
                BpCoordRegion newRegion = new BpCoordRegion(request.start, request.end);
                if (overlap.start.equals(request.start)) {
                    newRegion.start = overlap.end;
                } else if (overlap.end.equals(request.end)) {
                    newRegion.end = overlap.start;
                }
                fileRequest.areaRequest = new AreaRequest(newRegion, request.requestedContents, request.status, request.depthToGo);
            }
            this.previousRequestedRegion = request;
            this.fetchReads(fileRequest);
        }
    }

    public void fetchReads(SAMFileRequest fileRequest) {
        AreaRequest request = fileRequest.areaRequest;
        String chromosome = this.dataSource.getChromosomeNameUnnormaliser().unnormalise(request.start.chr);
        SAMRecordIterator iterator = this.dataSource.getReader().query(chromosome, request.start.bp.intValue(), request.end.bp.intValue(), false);
        while (iterator.hasNext()) {
            LinkedList<RegionContent> responseList = new LinkedList<RegionContent>();
            for (int c = 0; c < 500 && iterator.hasNext(); ++c) {
                SAMRecord record = (SAMRecord)iterator.next();
                BpCoordRegion recordRegion = new BpCoordRegion(Long.valueOf(record.getAlignmentStart()), Long.valueOf(record.getAlignmentEnd()), request.start.chr);
                LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
                RegionContent read = new RegionContent(recordRegion, values);
                if (request.requestedContents.contains((Object)ColumnType.ID)) {
                    values.put(ColumnType.ID, record.getReadName());
                }
                if (request.requestedContents.contains((Object)ColumnType.STRAND)) {
                    values.put(ColumnType.STRAND, (Object)(record.getReadNegativeStrandFlag() ? Strand.REVERSED : Strand.FORWARD));
                }
                if (request.requestedContents.contains((Object)ColumnType.QUALITY)) {
                    values.put(ColumnType.QUALITY, record.getBaseQualityString());
                }
                if (request.requestedContents.contains((Object)ColumnType.CIGAR)) {
                    Cigar cigar = new Cigar(read, record.getCigar());
                    values.put(ColumnType.CIGAR, cigar);
                }
                if (request.requestedContents.contains((Object)ColumnType.SEQUENCE)) {
                    String seq = record.getReadString();
                    values.put(ColumnType.SEQUENCE, seq);
                }
                responseList.add(read);
            }
            SAMFileResult result = new SAMFileResult(responseList, fileRequest, fileRequest.areaRequest, fileRequest.getStatus());
            this.fileResultQueue.add(result);
            this.areaRequestThread.notifyAreaRequestHandler();
        }
        iterator.close();
    }

    private void sampleToGetConcisedRegion(SAMFileRequest request) {
        BpCoord from = request.getFrom();
        BpCoord to = request.getTo();
        long stepMiddlepoint = (from.bp + to.bp) / 2L;
        long start = stepMiddlepoint - 50L;
        long end = stepMiddlepoint + 50L;
        SAMRecordIterator iterator = this.dataSource.getReader().query(this.dataSource.getChromosomeNameUnnormaliser().unnormalise(from.chr), (int)start, (int)end, false);
        int countForward = 0;
        int countReverse = 0;
        SAMRecordIterator i = iterator;
        while (i.hasNext()) {
            SAMRecord record = (SAMRecord)i.next();
            if ((long)record.getAlignmentStart() < start || (long)record.getAlignmentEnd() > end) continue;
            if (record.getReadNegativeStrandFlag()) {
                ++countReverse;
                continue;
            }
            ++countForward;
        }
        iterator.close();
        LinkedList<RegionContent> content = new LinkedList<RegionContent>();
        content.add(new RegionContent(new BpCoordRegion(from, to), countForward, countReverse));
        SAMFileResult result = new SAMFileResult(content, request, request.areaRequest, request.getStatus());
        this.fileResultQueue.add(result);
        this.areaRequestThread.notifyAreaRequestHandler();
    }
}

