/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueManager
implements AreaResultListener {
    private Map<DataSource, QueueContext> queues = new HashMap<DataSource, QueueContext>();

    public void createQueue(DataSource file, Class<? extends AreaRequestHandler> dataFetcher) {
        if (!this.queues.containsKey(file)) {
            QueueContext context = new QueueContext();
            context.queue = new ConcurrentLinkedQueue<AreaRequest>();
            try {
                context.thread = dataFetcher.getConstructor(DataSource.class, Queue.class, AreaResultListener.class).newInstance(file, context.queue, this);
                this.queues.put(file, context);
                context.thread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeQueue(DataSource file) {
        this.queues.remove(file);
    }

    public void addAreaRequest(DataSource file, AreaRequest req, boolean clearQueues) {
        req.status.file = file;
        QueueContext context = this.queues.get(file);
        req.status.maybeClearQueue(context.queue);
        context.queue.add(req);
        context.thread.notifyAreaRequestHandler();
    }

    public void addResultListener(DataSource file, AreaResultListener listener) {
        this.queues.get((Object)file).listeners.add(listener);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (AreaResultListener listener : this.queues.get((Object)areaResult.getStatus().file).listeners) {
            listener.processAreaResult(areaResult);
        }
    }

    private class QueueContext {
        public Queue<AreaRequest> queue;
        public Collection<AreaResultListener> listeners = new ArrayList<AreaResultListener>();
        public AreaRequestHandler thread;

        private QueueContext() {
        }
    }
}

