/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CytobandTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GeneTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PeakTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadSummaryTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.WIGTrack;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;

public class TrackFactory {
    public static TrackGroup addGeneTracks(GenomePlot genomePlot, ChunkDataSource geneAnnotationFile, DataSource transcriptAnnotationFile, ChunkDataSource refSource, DataSource snpFile) throws FileNotFoundException {
        View dataView = genomePlot.getDataView();
        GeneTrackGroup geneGroup = new GeneTrackGroup(dataView, geneAnnotationFile, transcriptAnnotationFile, refSource, snpFile);
        TrackFactory.addGroup(dataView, geneGroup);
        return geneGroup;
    }

    public static void addThickSeparatorTrack(GenomePlot genomePlot) {
        View dataView = genomePlot.getDataView();
        dataView.addTrack(new SeparatorTrack3D(dataView, 0L, Long.MAX_VALUE, false));
        dataView.addTrack(new EmptyTrack(dataView, 2));
        dataView.addTrack(new SeparatorTrack3D(dataView, 0L, Long.MAX_VALUE, true));
    }

    public static TrackGroup addReadTracks(GenomePlot genomePlot, DataSource userData, Class<? extends AreaRequestHandler> userDataHandler, DataSource seqFile, String title) throws FileNotFoundException, MalformedURLException {
        View dataView = genomePlot.getDataView();
        ReadTrackGroup readGroup = new ReadTrackGroup(dataView, userData, userDataHandler, seqFile, title);
        readGroup.initialise();
        TrackFactory.addGroup(dataView, readGroup);
        return readGroup;
    }

    public static TrackGroup addReadSummaryTracks(GenomePlot genomePlot, DataSource userData, Class<? extends AreaRequestHandler> userDataHandler, DataSource seqFile, String title, TabixDataSource summaryDataSource) throws FileNotFoundException, MalformedURLException {
        View dataView = genomePlot.getDataView();
        ReadSummaryTrackGroup readGroup = new ReadSummaryTrackGroup(dataView, userData, userDataHandler, seqFile, title, summaryDataSource);
        readGroup.initialise();
        TrackFactory.addGroup(dataView, readGroup);
        return readGroup;
    }

    public static void addWigTrack(GenomePlot plot, DataSource peakFile) {
        WIGTrack annotation = new WIGTrack(plot.getDataView(), peakFile, ChunkTreeHandlerThread.class, Color.BLUE, 0L, Long.MAX_VALUE);
        TrackFactory.addTrack(plot.getDataView(), annotation);
    }

    public static void addPeakTrack(GenomePlot plot, DataSource peaks) {
        View dataView = plot.getDataView();
        PeakTrack annotation = new PeakTrack(dataView, peaks, ChunkTreeHandlerThread.class, VisualConstants.BED_COLOR, 0L, Long.MAX_VALUE);
        TrackFactory.addTrack(dataView, annotation);
    }

    public static void addHeaderPeakTrack(GenomePlot plot, DataSource peaks) {
        View dataView = plot.getDataView();
        PeakTrack annotation = new PeakTrack(dataView, peaks, ChunkTreeHandlerThread.class, VisualConstants.BED_COLOR, 0L, Long.MAX_VALUE);
        TrackFactory.addTrack(dataView, annotation);
    }

    public static void addTranscriptTracks(GenomePlot plot, DataSource transcriptAnnotationFile) {
    }

    public static void addCytobandTracks(GenomePlot plot, ChunkDataSource cytobandData) {
        CytobandTrack overviewCytobands = new CytobandTrack(plot.getOverviewView(), cytobandData, ChunkTreeHandlerThread.class, false);
        TrackFactory.addTrack(plot.getOverviewView(), overviewCytobands);
    }

    public static void addRulerTrack(GenomePlot plot) {
        plot.getDataView().addTrack(new RulerTrack(plot.getDataView()));
    }

    private static void addTrack(View view, Track track) {
        view.addTrack(track);
        track.initializeListener();
    }

    private static void addGroup(View view, TrackGroup group) {
        view.addTrackGroup(group);
        for (Track track : group.getTracks()) {
            if (!track.hasData()) continue;
            track.initializeListener();
        }
    }

    public static void addTitleTrack(GenomePlot genomePlot, String title) {
        View dataView = genomePlot.getDataView();
        dataView.addTrack(new TitleTrack(dataView, title, Color.black));
    }
}

