/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ChromosomeNameUnnormaliser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Iterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceRecord;

public class SAMDataSource
extends DataSource {
    private ChromosomeNameUnnormaliser chromosomeNameUnnormaliser = ChromosomeNameUnnormaliser.newIdentityPreversingUnnormaliser();
    private SAMFileReader reader;

    public SAMDataSource(File samFile, File indexFile) throws FileNotFoundException {
        super(samFile);
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        this.reader = new SAMFileReader(samFile, indexFile);
        Iterator i$ = this.reader.getFileHeader().getSequenceDictionary().getSequences().iterator();
        if (i$.hasNext()) {
            SAMSequenceRecord sequenceRecord = (SAMSequenceRecord)i$.next();
            this.chromosomeNameUnnormaliser = new ChromosomeNameUnnormaliser(sequenceRecord.getSequenceName());
        }
        System.setErr(originalErr);
    }

    public SAMFileReader getReader() {
        return this.reader;
    }

    public ChromosomeNameUnnormaliser getChromosomeNameUnnormaliser() {
        return this.chromosomeNameUnnormaliser;
    }
}

