/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.Empty;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.List;
import javax.swing.ImageIcon;

public class VisualisationMethod {
    public static VisualisationMethod NONE = new VisualisationMethod("None                                   ", Empty.class, VisualConstants.EMPTY_MENUICON, 0, 0.0);
    private final ClientApplication application = Session.getSession().getApplication();
    private String name;
    private Class<? extends Visualisation> visualiser;
    private ImageIcon icon;
    private int orderNumber;
    private double durationEstimationFactor;
    private String helpAddress = null;

    public String getName() {
        return this.name;
    }

    public VisualisationMethod(String name, Class<? extends Visualisation> visualiser, ImageIcon icon, int orderNumber, double durationEstimationFactor) {
        this.name = name;
        this.visualiser = visualiser;
        this.icon = icon;
        this.orderNumber = orderNumber;
        this.durationEstimationFactor = durationEstimationFactor;
    }

    public VisualisationMethod(String name, Class<? extends Visualisation> visualiser, ImageIcon icon, int orderNumber, double durationEstimationFactor, String helpAddress) {
        this(name, visualiser, icon, orderNumber, durationEstimationFactor);
        this.helpAddress = helpAddress;
    }

    public String toString() {
        return this.name;
    }

    public Class<? extends Visualisation> getVisualiserClass() {
        return this.visualiser;
    }

    public Visualisation getVisualiser(VisualisationFrame frame) {
        try {
            Visualisation visualisation = this.visualiser.getConstructor(new Class[0]).newInstance(new Object[0]);
            visualisation.initialise(frame);
            return visualisation;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.application.reportException(e);
            return null;
        }
    }

    public Visualisation getHeadlessVisualiser() {
        try {
            return this.visualiser.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.application.reportException(e);
            return null;
        }
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public static VisualisationMethod getDefault() {
        return NONE;
    }

    public long estimateDuration(List<DataBean> datas) {
        if (datas.size() > 0) {
            return (long)((double)datas.get(0).getContentLength() * this.durationEstimationFactor * (double)datas.size());
        }
        return -1L;
    }

    public boolean isApplicableTo(DataBean bean) throws MicroarrayException {
        if (bean != null) {
            return this.getHeadlessVisualiser().canVisualise(bean);
        }
        return false;
    }

    public boolean isApplicableTo(List<DataBean> beans) throws MicroarrayException {
        if (!this.getHeadlessVisualiser().isForMultipleDatas()) {
            return false;
        }
        return this.getHeadlessVisualiser().canVisualise(beans);
    }

    public String getHelpAddress() {
        return this.helpAddress;
    }
}

