/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.ActiveMQMessageAuditNoSync;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.Visitor;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaLocalTransactionId;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaProducerAuditCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaRollbackCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaXATransactionId;
import org.apache.activemq.util.Callback;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.index.BTreeIndex;
import org.apache.kahadb.index.BTreeVisitor;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.PageFile;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayInputStream;
import org.apache.kahadb.util.DataByteArrayOutputStream;
import org.apache.kahadb.util.LockFile;
import org.apache.kahadb.util.LongMarshaller;
import org.apache.kahadb.util.Marshaller;
import org.apache.kahadb.util.Sequence;
import org.apache.kahadb.util.SequenceSet;
import org.apache.kahadb.util.StringMarshaller;
import org.apache.kahadb.util.VariableMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDatabase
extends ServiceSupport
implements BrokerServiceAware {
    protected BrokerService brokerService;
    public static final String PROPERTY_LOG_SLOW_ACCESS_TIME = "org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME";
    public static final int LOG_SLOW_ACCESS_TIME = Integer.parseInt(System.getProperty("org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME", "0"));
    protected static final Buffer UNMATCHED = new Buffer(new byte[0]);
    private static final Log LOG = LogFactory.getLog(MessageDatabase.class);
    private static final int DEFAULT_DATABASE_LOCKED_WAIT_DELAY = 10000;
    static final int CLOSED_STATE = 1;
    static final int OPEN_STATE = 2;
    static final long NOT_ACKED = -1L;
    static final long UNMATCHED_SEQ = -2L;
    static final int VERSION = 3;
    protected PageFile pageFile;
    protected Journal journal;
    protected Metadata metadata = new Metadata();
    protected MetadataMarshaller metadataMarshaller = new MetadataMarshaller();
    protected boolean failIfDatabaseIsLocked;
    protected boolean deleteAllMessages;
    protected File directory = new File("KahaDB");
    protected Thread checkpointThread;
    protected boolean enableJournalDiskSyncs = true;
    protected boolean archiveDataLogs;
    protected File directoryArchive;
    protected AtomicLong storeSize = new AtomicLong(0L);
    long checkpointInterval = 5000L;
    long cleanupInterval = 30000L;
    int journalMaxFileLength = 0x2000000;
    int journalMaxWriteBatchSize = 0x400000;
    boolean enableIndexWriteAsync = false;
    int setIndexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    protected AtomicBoolean opened = new AtomicBoolean();
    private LockFile lockFile;
    private boolean ignoreMissingJournalfiles = false;
    private int indexCacheSize = 10000;
    private boolean checkForCorruptJournalFiles = false;
    private boolean checksumJournalFiles = false;
    private int databaseLockedWaitDelay = 10000;
    protected boolean forceRecoverIndex = false;
    private Location nextRecoveryPosition;
    private Location lastRecoveryPosition;
    protected final ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
    private final HashSet<Integer> journalFilesBeingReplicated = new HashSet();
    Map<Integer, Set<Integer>> ackMessageFileMap = new HashMap<Integer, Set<Integer>>();
    private final HashMap<String, StoredDestination> storedDestinations = new HashMap();
    protected final LinkedHashMap<TransactionId, List<Operation>> inflightTransactions = new LinkedHashMap();
    protected final LinkedHashMap<TransactionId, List<Operation>> preparedTransactions = new LinkedHashMap();

    @Override
    public void doStart() throws Exception {
        this.load();
    }

    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        this.unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPageFile() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            final PageFile pageFile = this.getPageFile();
            pageFile.load();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    if (pageFile.getPageCount() == 0L) {
                        Page<Metadata> page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set(MessageDatabase.this.metadata);
                        MessageDatabase.this.metadata.page = page;
                        MessageDatabase.this.metadata.state = 1;
                        MessageDatabase.this.metadata.destinations = new BTreeIndex(pageFile, tx.allocate().getPageId());
                        tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                    } else {
                        Page<Metadata> page = tx.load(0L, MessageDatabase.this.metadataMarshaller);
                        MessageDatabase.this.metadata = page.get();
                        MessageDatabase.this.metadata.page = page;
                    }
                    MessageDatabase.this.metadata.destinations.setKeyMarshaller(StringMarshaller.INSTANCE);
                    MessageDatabase.this.metadata.destinations.setValueMarshaller(new StoredDestinationMarshaller());
                    MessageDatabase.this.metadata.destinations.load(tx);
                }
            });
            this.storedDestinations.clear();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Iterator<Map.Entry<String, StoredDestination>> iterator = MessageDatabase.this.metadata.destinations.iterator(tx);
                    while (iterator.hasNext()) {
                        Map.Entry<String, StoredDestination> entry = iterator.next();
                        StoredDestination sd = MessageDatabase.this.loadStoredDestination(tx, entry.getKey(), entry.getValue().subscriptions != null);
                        MessageDatabase.this.storedDestinations.put(entry.getKey(), sd);
                    }
                }
            });
            pageFile.flush();
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private void startCheckpoint() {
        this.checkpointThread = new Thread("ActiveMQ Journal Checkpoint Worker"){

            public void run() {
                try {
                    long lastCleanup = System.currentTimeMillis();
                    long lastCheckpoint = System.currentTimeMillis();
                    long sleepTime = Math.min(MessageDatabase.this.checkpointInterval, 500L);
                    while (MessageDatabase.this.opened.get()) {
                        Thread.sleep(sleepTime);
                        long now = System.currentTimeMillis();
                        if (now - lastCleanup >= MessageDatabase.this.cleanupInterval) {
                            MessageDatabase.this.checkpointCleanup(true);
                            lastCleanup = now;
                            lastCheckpoint = now;
                            continue;
                        }
                        if (now - lastCheckpoint < MessageDatabase.this.checkpointInterval) continue;
                        MessageDatabase.this.checkpointCleanup(false);
                        lastCheckpoint = now;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (IOException ioe) {
                    LOG.error("Checkpoint failed", ioe);
                    MessageDatabase.this.brokerService.handleIOException(ioe);
                }
            }
        };
        this.checkpointThread.setDaemon(true);
        this.checkpointThread.start();
    }

    public void open() throws IOException {
        if (this.opened.compareAndSet(false, true)) {
            this.getJournal().start();
            this.loadPageFile();
            this.startCheckpoint();
            this.recover();
        }
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info("Database " + lockFileName + " is locked... waiting " + this.getDatabaseLockedWaitDelay() / 1000 + " seconds for the database to be unlocked. Reason: " + e);
                        try {
                            Thread.sleep(this.getDatabaseLockedWaitDelay());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.lock();
            if (this.deleteAllMessages) {
                this.getJournal().start();
                this.getJournal().delete();
                this.getJournal().close();
                this.journal = null;
                this.getPageFile().delete();
                LOG.info("Persistence store purged.");
                this.deleteAllMessages = false;
            }
            this.open();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (this.opened.compareAndSet(true, false)) {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.checkpointUpdate(tx, true);
                    }
                });
                this.pageFile.unload();
                this.metadata = new Metadata();
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
            this.journal.close();
            this.checkpointThread.join();
            this.lockFile.unlock();
            this.lockFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException, InterruptedException {
        this.indexLock.writeLock().lock();
        try {
            if (this.pageFile != null && this.pageFile.isLoaded()) {
                this.metadata.state = 1;
                this.metadata.firstInProgressTransactionLocation = this.getFirstInProgressTxLocation();
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                    }
                });
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getFirstInProgressTxLocation() {
        Location l = null;
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            if (!this.inflightTransactions.isEmpty()) {
                l = this.inflightTransactions.values().iterator().next().get(0).getLocation();
            }
            if (!this.preparedTransactions.isEmpty()) {
                Location t = this.preparedTransactions.values().iterator().next().get(0).getLocation();
                if (l == null || t.compareTo(l) <= 0) {
                    l = t;
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IllegalStateException, IOException {
        this.indexLock.writeLock().lock();
        try {
            long start = System.currentTimeMillis();
            Location producerAuditPosition = this.recoverProducerAudit();
            Location lastIndoubtPosition = this.getRecoveryPosition();
            Location recoveryPosition = this.minimum(producerAuditPosition, lastIndoubtPosition);
            if (recoveryPosition != null) {
                int redoCounter = 0;
                LOG.info("Recovering from the journal ...");
                while (recoveryPosition != null) {
                    JournalCommand<?> message = this.load(recoveryPosition);
                    this.metadata.lastUpdate = recoveryPosition;
                    this.process(message, recoveryPosition, lastIndoubtPosition);
                    ++redoCounter;
                    recoveryPosition = this.journal.getNextLocation(recoveryPosition);
                }
                long end = System.currentTimeMillis();
                LOG.info("Recovery replayed " + redoCounter + " operations from the journal in " + (float)(end - start) / 1000.0f + " seconds.");
            }
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.recoverIndex(tx);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private Location minimum(Location producerAuditPosition, Location lastIndoubtPosition) {
        Location min = null;
        if (producerAuditPosition != null) {
            min = producerAuditPosition;
            if (lastIndoubtPosition != null && lastIndoubtPosition.compareTo(producerAuditPosition) < 0) {
                min = lastIndoubtPosition;
            }
        } else {
            min = lastIndoubtPosition;
        }
        return min;
    }

    private Location recoverProducerAudit() throws IOException {
        if (this.metadata.producerSequenceIdTrackerLocation != null) {
            KahaProducerAuditCommand audit = (KahaProducerAuditCommand)this.load(this.metadata.producerSequenceIdTrackerLocation);
            try {
                ObjectInputStream objectIn = new ObjectInputStream(audit.getAudit().newInput());
                this.metadata.producerSequenceIdTracker = (ActiveMQMessageAuditNoSync)objectIn.readObject();
            }
            catch (ClassNotFoundException cfe) {
                IOException ioe = new IOException("Failed to read producerAudit: " + cfe);
                ioe.initCause(cfe);
                throw ioe;
            }
            return this.journal.getNextLocation(this.metadata.producerSequenceIdTrackerLocation);
        }
        return this.journal.getNextLocation(null);
    }

    protected void recoverIndex(Transaction tx) throws IOException {
        long start = System.currentTimeMillis();
        Location lastAppendLocation = this.journal.getLastAppendLocation();
        long undoCounter = 0L;
        for (StoredDestination sd : this.storedDestinations.values()) {
            final ArrayList matches = new ArrayList();
            sd.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.GTEVisitor<Location, Long>(lastAppendLocation){

                @Override
                protected void matched(Location key, Long value) {
                    matches.add(value);
                }
            });
            for (Long sequenceId : matches) {
                MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                sd.locationIndex.remove(tx, keys.location);
                sd.messageIdIndex.remove(tx, keys.messageId);
                this.metadata.producerSequenceIdTracker.rollback(new MessageId(keys.messageId));
                ++undoCounter;
            }
        }
        long end = System.currentTimeMillis();
        if (undoCounter > 0L) {
            LOG.info("Rolled back " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds.");
        }
        undoCounter = 0L;
        start = System.currentTimeMillis();
        final SequenceSet ss = new SequenceSet();
        for (StoredDestination sd : this.storedDestinations.values()) {
            sd.locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                int last = -1;

                @Override
                public boolean isInterestedInKeysBetween(Location first, Location second) {
                    if (first == null) {
                        return !ss.contains(0, second.getDataFileId());
                    }
                    if (second == null) {
                        return true;
                    }
                    return !ss.contains(first.getDataFileId(), second.getDataFileId());
                }

                @Override
                public void visit(List<Location> keys, List<Long> values) {
                    for (Location l : keys) {
                        int fileId = l.getDataFileId();
                        if (this.last == fileId) continue;
                        ss.add(fileId);
                        this.last = fileId;
                    }
                }
            });
        }
        HashSet<Integer> missingJournalFiles = new HashSet<Integer>();
        while (!ss.isEmpty()) {
            missingJournalFiles.add((int)ss.removeFirst());
        }
        missingJournalFiles.removeAll(this.journal.getFileMap().keySet());
        if (!missingJournalFiles.isEmpty()) {
            LOG.info("Some journal files are missing: " + missingJournalFiles);
        }
        ArrayList missingPredicates = new ArrayList();
        for (Integer missing : missingJournalFiles) {
            missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(missing, 0), new Location(missing + 1, 0)));
        }
        if (this.checkForCorruptJournalFiles) {
            Collection<DataFile> dataFiles = this.journal.getFileMap().values();
            for (DataFile dataFile : dataFiles) {
                int id = dataFile.getDataFileId();
                missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(id, dataFile.getLength()), new Location(id + 1, 0)));
                for (Sequence seq = (Sequence)dataFile.getCorruptedBlocks().getHead(); seq != null; seq = (Sequence)seq.getNext()) {
                    missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(id, (int)seq.getFirst()), new Location(id, (int)seq.getLast() + 1)));
                }
            }
        }
        if (!missingPredicates.isEmpty()) {
            for (StoredDestination sd : this.storedDestinations.values()) {
                final ArrayList matches = new ArrayList();
                sd.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.OrVisitor<Location, Long>(missingPredicates){

                    @Override
                    protected void matched(Location key, Long value) {
                        matches.add(value);
                    }
                });
                if (matches.isEmpty()) continue;
                if (this.ignoreMissingJournalfiles) {
                    for (Long sequenceId : matches) {
                        MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                        sd.locationIndex.remove(tx, keys.location);
                        sd.messageIdIndex.remove(tx, keys.messageId);
                        ++undoCounter;
                    }
                    continue;
                }
                throw new IOException("Detected missing/corrupt journal files. " + matches.size() + " messages affected.");
            }
        }
        end = System.currentTimeMillis();
        if (undoCounter > 0L) {
            LOG.info("Detected missing/corrupt journal files.  Dropped " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementalRecover() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            if (this.nextRecoveryPosition == null) {
                this.nextRecoveryPosition = this.lastRecoveryPosition == null ? this.getRecoveryPosition() : this.journal.getNextLocation(this.lastRecoveryPosition);
            }
            while (this.nextRecoveryPosition != null) {
                this.metadata.lastUpdate = this.lastRecoveryPosition = this.nextRecoveryPosition;
                JournalCommand<?> message = this.load(this.lastRecoveryPosition);
                this.process(message, this.lastRecoveryPosition);
                this.nextRecoveryPosition = this.journal.getNextLocation(this.lastRecoveryPosition);
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    public Location getLastUpdatePosition() throws IOException {
        return this.metadata.lastUpdate;
    }

    private Location getRecoveryPosition() throws IOException {
        if (!this.forceRecoverIndex) {
            if (this.metadata.firstInProgressTransactionLocation != null) {
                return this.metadata.firstInProgressTransactionLocation;
            }
            if (this.metadata.lastUpdate != null) {
                return this.journal.getNextLocation(this.metadata.lastUpdate);
            }
        }
        return this.journal.getNextLocation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpointCleanup(final boolean cleanup) throws IOException {
        long start;
        this.indexLock.writeLock().lock();
        try {
            start = System.currentTimeMillis();
            if (!this.opened.get()) {
                return;
            }
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.checkpointUpdate(tx, cleanup);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME) {
            LOG.info("Slow KahaDB access: cleanup took " + (end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(Callback closure) throws Exception {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.checkpointUpdate(tx, false);
                }
            });
            closure.execute();
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    public Location store(JournalCommand<?> data) throws IOException {
        return this.store(data, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location store(JournalCommand<?> data, boolean sync, Runnable before, Runnable after) throws IOException {
        if (before != null) {
            before.run();
        }
        try {
            int size = data.serializedSizeFramed();
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
            os.writeByte(data.type().getNumber());
            data.writeFramed(os);
            long start = System.currentTimeMillis();
            Location location = this.journal.write(os.toByteSequence(), sync);
            long start2 = System.currentTimeMillis();
            this.process(data, location);
            long end = System.currentTimeMillis();
            if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME) {
                LOG.info("Slow KahaDB access: Journal append took: " + (start2 - start) + " ms, Index update took " + (end - start2) + " ms");
            }
            this.indexLock.writeLock().lock();
            try {
                this.metadata.lastUpdate = location;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
            if (!this.checkpointThread.isAlive()) {
                LOG.info("KahaDB: Recovering checkpoint thread after exception");
                this.startCheckpoint();
            }
            if (after != null) {
                after.run();
            }
            return location;
        }
        catch (IOException ioe) {
            LOG.error("KahaDB failed to store to Journal", ioe);
            this.brokerService.handleIOException(ioe);
            throw ioe;
        }
    }

    public JournalCommand<?> load(Location location) throws IOException {
        ByteSequence data = this.journal.read(location);
        DataByteArrayInputStream is = new DataByteArrayInputStream(data);
        byte readByte = is.readByte();
        KahaEntryType type = KahaEntryType.valueOf(readByte);
        if (type == null) {
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed(is);
        return message;
    }

    void process(JournalCommand<?> data, Location location, Location inDoubtlocation) throws IOException {
        if (inDoubtlocation != null && location.compareTo(inDoubtlocation) >= 0) {
            this.process(data, location);
        } else {
            data.visit(new Visitor(){

                public void visit(KahaAddMessageCommand command) throws IOException {
                    MessageDatabase.this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
                }
            });
        }
    }

    void process(JournalCommand<?> data, final Location location) throws IOException {
        data.visit(new Visitor(){

            public void visit(KahaAddMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRemoveMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaPrepareCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaCommitCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRollbackCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRemoveDestinationCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaSubscriptionCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaAddMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo(), location);
            inflightTx.add(new AddOpperation(command, location));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.upadateIndex(tx, command, location);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo(), location);
            inflightTx.add(new RemoveOpperation(command, location));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.updateIndex(tx, command, location);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveDestinationCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaSubscriptionCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaCommitCommand command, Location location) throws IOException {
        List inflightTx;
        TransactionId key = this.key(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            inflightTx = (List)this.inflightTransactions.remove(key);
            if (inflightTx == null) {
                inflightTx = (List)this.preparedTransactions.remove(key);
            }
        }
        if (inflightTx == null) {
            return;
        }
        final List messagingTx = inflightTx;
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    for (Operation op : messagingTx) {
                        op.execute(tx);
                    }
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaPrepareCommand command, Location location) {
        TransactionId key = this.key(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            List tx = (List)this.inflightTransactions.remove(key);
            if (tx != null) {
                this.preparedTransactions.put(key, tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaRollbackCommand command, Location location) {
        TransactionId key = this.key(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            List tx = (List)this.inflightTransactions.remove(key);
            if (tx == null) {
                this.preparedTransactions.remove(key);
            }
        }
    }

    void upadateIndex(Transaction tx, KahaAddMessageCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (sd.subscriptions != null && sd.subscriptions.isEmpty(tx)) {
            return;
        }
        int priority = command.getPrioritySupported() ? command.getPriority() : 4;
        long id = sd.orderIndex.getNextMessageId(priority);
        Long previous = sd.locationIndex.put(tx, location, id);
        if (previous == null) {
            previous = sd.messageIdIndex.put(tx, command.getMessageId(), id);
            if (previous == null) {
                sd.orderIndex.put(tx, priority, id, new MessageKeys(command.getMessageId(), location));
                if (sd.subscriptions != null && !sd.subscriptions.isEmpty(tx)) {
                    this.addAckLocationForNewMessage(tx, sd, id);
                }
            } else {
                LOG.warn("Duplicate message add attempt rejected. Destination: " + command.getDestination().getName() + ", Message id: " + command.getMessageId());
                sd.messageIdIndex.put(tx, command.getMessageId(), previous);
                sd.locationIndex.remove(tx, location);
            }
        } else {
            sd.locationIndex.put(tx, location, previous);
        }
        this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
    }

    void updateIndex(Transaction tx, KahaRemoveMessageCommand command, Location ackLocation) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (!command.hasSubscriptionKey()) {
            MessageKeys keys;
            Long sequenceId = sd.messageIdIndex.remove(tx, command.getMessageId());
            if (sequenceId != null && (keys = sd.orderIndex.remove(tx, sequenceId)) != null) {
                sd.locationIndex.remove(tx, keys.location);
                this.recordAckMessageReferenceLocation(ackLocation, keys.location);
            }
        } else {
            Long sequence = sd.messageIdIndex.get(tx, command.getMessageId());
            if (sequence != null) {
                String subscriptionKey = command.getSubscriptionKey();
                if (command.getAck() != UNMATCHED) {
                    sd.orderIndex.get(tx, sequence);
                    byte priority = sd.orderIndex.lastGetPriority();
                    sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(sequence, priority));
                }
                this.removeAckLocation(tx, sd, subscriptionKey, sequence);
            }
        }
    }

    private void recordAckMessageReferenceLocation(Location ackLocation, Location messageLocation) {
        Set<Integer> referenceFileIds = this.ackMessageFileMap.get(ackLocation.getDataFileId());
        if (referenceFileIds == null) {
            referenceFileIds = new HashSet<Integer>();
            referenceFileIds.add(messageLocation.getDataFileId());
            this.ackMessageFileMap.put(ackLocation.getDataFileId(), referenceFileIds);
        } else {
            Integer id = messageLocation.getDataFileId();
            if (!referenceFileIds.contains(id)) {
                referenceFileIds.add(id);
            }
        }
    }

    void updateIndex(Transaction tx, KahaRemoveDestinationCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        sd.orderIndex.remove(tx);
        sd.locationIndex.clear(tx);
        sd.locationIndex.unload(tx);
        tx.free(sd.locationIndex.getPageId());
        sd.messageIdIndex.clear(tx);
        sd.messageIdIndex.unload(tx);
        tx.free(sd.messageIdIndex.getPageId());
        if (sd.subscriptions != null) {
            sd.subscriptions.clear(tx);
            sd.subscriptions.unload(tx);
            tx.free(sd.subscriptions.getPageId());
            sd.subscriptionAcks.clear(tx);
            sd.subscriptionAcks.unload(tx);
            tx.free(sd.subscriptionAcks.getPageId());
            sd.ackPositions.clear(tx);
            sd.ackPositions.unload(tx);
            tx.free(sd.ackPositions.getPageId());
        }
        String key = this.key(command.getDestination());
        this.storedDestinations.remove(key);
        this.metadata.destinations.remove(tx, key);
    }

    void updateIndex(Transaction tx, KahaSubscriptionCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (command.hasSubscriptionInfo()) {
            String subscriptionKey = command.getSubscriptionKey();
            sd.subscriptions.put(tx, subscriptionKey, command);
            long ackLocation = -1L;
            if (!command.getRetroactive()) {
                ackLocation = sd.orderIndex.nextMessageId - 1L;
            } else {
                this.addAckLocationForRetroactiveSub(tx, sd, ackLocation, subscriptionKey);
            }
            sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(ackLocation));
        } else {
            String subscriptionKey = command.getSubscriptionKey();
            sd.subscriptions.remove(tx, subscriptionKey);
            sd.subscriptionAcks.remove(tx, subscriptionKey);
            this.removeAckLocationsForSub(tx, sd, subscriptionKey);
        }
    }

    void checkpointUpdate(Transaction tx, boolean cleanup) throws IOException {
        LOG.debug("Checkpoint started.");
        this.metadata.state = 2;
        this.metadata.producerSequenceIdTrackerLocation = this.checkpointProducerAudit();
        this.metadata.firstInProgressTransactionLocation = this.getFirstInProgressTxLocation();
        tx.store(this.metadata.page, this.metadataMarshaller, true);
        this.pageFile.flush();
        if (cleanup) {
            final TreeSet<Integer> gcCandidateSet = new TreeSet<Integer>(this.journal.getFileMap().keySet());
            if (this.journalFilesBeingReplicated != null) {
                gcCandidateSet.removeAll(this.journalFilesBeingReplicated);
            }
            Location firstTxLocation = this.metadata.lastUpdate;
            if (this.metadata.firstInProgressTransactionLocation != null) {
                firstTxLocation = this.metadata.firstInProgressTransactionLocation;
            }
            if (firstTxLocation != null) {
                Integer last;
                while (!gcCandidateSet.isEmpty() && (last = gcCandidateSet.last()) >= firstTxLocation.getDataFileId()) {
                    gcCandidateSet.remove(last);
                }
                LOG.trace("gc candidates after first tx:" + firstTxLocation.getDataFileId() + ", " + gcCandidateSet);
            }
            for (Map.Entry<String, StoredDestination> entry : this.storedDestinations.entrySet()) {
                if (gcCandidateSet.isEmpty()) break;
                entry.getValue().locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                    int last = -1;

                    @Override
                    public boolean isInterestedInKeysBetween(Location first, Location second) {
                        if (first == null) {
                            SortedSet<Integer> subset = gcCandidateSet.headSet(second.getDataFileId() + 1);
                            if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                                subset.remove(second.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        if (second == null) {
                            SortedSet<Integer> subset = gcCandidateSet.tailSet(first.getDataFileId());
                            if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                                subset.remove(first.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        SortedSet<Integer> subset = gcCandidateSet.subSet(first.getDataFileId(), second.getDataFileId() + 1);
                        if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                            subset.remove(first.getDataFileId());
                        }
                        if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                            subset.remove(second.getDataFileId());
                        }
                        return !subset.isEmpty();
                    }

                    @Override
                    public void visit(List<Location> keys, List<Long> values) {
                        for (Location l : keys) {
                            int fileId = l.getDataFileId();
                            if (this.last == fileId) continue;
                            gcCandidateSet.remove(fileId);
                            this.last = fileId;
                        }
                    }
                });
                LOG.trace("gc candidates after dest:" + entry.getKey() + ", " + gcCandidateSet);
            }
            LOG.trace("gc candidates: " + gcCandidateSet);
            TreeSet<Integer> gcCandidates = new TreeSet<Integer>((SortedSet<Integer>)gcCandidateSet);
            Iterator<Integer> candidates = gcCandidateSet.iterator();
            while (candidates.hasNext()) {
                Integer candidate = candidates.next();
                Set<Integer> referencedFileIds = this.ackMessageFileMap.get(candidate);
                if (referencedFileIds == null) continue;
                for (Integer referencedFileId : referencedFileIds) {
                    if (!this.journal.getFileMap().containsKey(referencedFileId) || gcCandidates.contains(referencedFileId)) continue;
                    candidates.remove();
                    break;
                }
                if (gcCandidateSet.contains(candidate)) {
                    this.ackMessageFileMap.remove(candidate);
                    continue;
                }
                LOG.trace("not removing data file: " + candidate + " as contained ack(s) refer to referenced file: " + referencedFileIds);
            }
            if (!gcCandidateSet.isEmpty()) {
                LOG.debug("Cleanup removing the data files: " + gcCandidateSet);
                this.journal.removeDataFiles(gcCandidateSet);
            }
        }
        LOG.debug("Checkpoint done.");
    }

    private Location checkpointProducerAudit() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(this.metadata.producerSequenceIdTracker);
        oout.flush();
        oout.close();
        return this.store((JournalCommand)new KahaProducerAuditCommand().setAudit(new Buffer(baos.toByteArray())));
    }

    public HashSet<Integer> getJournalFilesBeingReplicated() {
        return this.journalFilesBeingReplicated;
    }

    protected StoredDestination getStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null) {
            boolean topic = destination.getType() == KahaDestination.DestinationType.TOPIC || destination.getType() == KahaDestination.DestinationType.TEMP_TOPIC;
            rc = this.loadStoredDestination(tx, key, topic);
            this.storedDestinations.put(key, rc);
        }
        return rc;
    }

    protected StoredDestination getExistingStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null && this.metadata.destinations.containsKey(tx, key)) {
            rc = this.getStoredDestination(destination, tx);
        }
        return rc;
    }

    private StoredDestination loadStoredDestination(Transaction tx, String key, boolean topic) throws IOException {
        StoredDestination rc = this.metadata.destinations.get(tx, key);
        if (rc == null) {
            rc = new StoredDestination();
            rc.orderIndex.allocate(tx);
            rc.locationIndex = new BTreeIndex(this.pageFile, tx.allocate());
            rc.messageIdIndex = new BTreeIndex(this.pageFile, tx.allocate());
            if (topic) {
                rc.subscriptions = new BTreeIndex(this.pageFile, tx.allocate());
                rc.subscriptionAcks = new BTreeIndex(this.pageFile, tx.allocate());
                rc.ackPositions = new BTreeIndex(this.pageFile, tx.allocate());
            }
            this.metadata.destinations.put(tx, key, rc);
        }
        rc.orderIndex.load(tx);
        rc.orderIndex.configureLast(tx);
        rc.locationIndex.setKeyMarshaller(LocationMarshaller.INSTANCE);
        rc.locationIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.locationIndex.load(tx);
        rc.messageIdIndex.setKeyMarshaller(StringMarshaller.INSTANCE);
        rc.messageIdIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.messageIdIndex.load(tx);
        if (topic) {
            Map.Entry<String, LastAck> entry;
            Iterator<Map.Entry<String, LastAck>> iterator;
            rc.subscriptions.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptions.setValueMarshaller(KahaSubscriptionCommandMarshaller.INSTANCE);
            rc.subscriptions.load(tx);
            rc.subscriptionAcks.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptionAcks.setValueMarshaller(new LastAckMarshaller());
            rc.subscriptionAcks.load(tx);
            rc.ackPositions.setKeyMarshaller(LongMarshaller.INSTANCE);
            rc.ackPositions.setValueMarshaller(HashSetStringMarshaller.INSTANCE);
            rc.ackPositions.load(tx);
            rc.subscriptionCursors = new HashMap();
            if (this.metadata.version < 3) {
                iterator = rc.subscriptionAcks.iterator(tx);
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Iterator<Map.Entry<Long, MessageKeys>> orderIterator = rc.orderIndex.iterator(tx, new MessageOrderCursor(entry.getValue().lastAckedSequence));
                    while (orderIterator.hasNext()) {
                        Long sequence = orderIterator.next().getKey();
                        this.addAckLocation(tx, rc, sequence, entry.getKey());
                    }
                    rc.subscriptionAcks.put(tx, entry.getKey(), entry.getValue());
                }
            }
            if (rc.orderIndex.nextMessageId == 0L && !rc.subscriptionAcks.isEmpty(tx)) {
                iterator = rc.subscriptionAcks.iterator(tx);
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    rc.orderIndex.nextMessageId = Math.max(rc.orderIndex.nextMessageId, entry.getValue().lastAckedSequence + 1L);
                }
            }
        }
        if (this.metadata.version < 3) {
            this.metadata.destinations.put(tx, key, rc);
        }
        return rc;
    }

    private void addAckLocation(Transaction tx, StoredDestination sd, Long messageSequence, String subscriptionKey) throws IOException {
        HashSet<String> hs = sd.ackPositions.get(tx, messageSequence);
        if (hs == null) {
            hs = new HashSet();
        }
        hs.add(subscriptionKey);
        sd.ackPositions.put(tx, messageSequence, hs);
    }

    private void addAckLocationForRetroactiveSub(Transaction tx, StoredDestination sd, Long messageSequence, String subscriptionKey) throws IOException {
        Iterator<Map.Entry<Long, HashSet<String>>> iterator = sd.ackPositions.iterator(tx, messageSequence);
        while (iterator.hasNext()) {
            Map.Entry<Long, HashSet<String>> entry = iterator.next();
            entry.getValue().add(subscriptionKey);
            sd.ackPositions.put(tx, entry.getKey(), entry.getValue());
        }
    }

    private void addAckLocationForNewMessage(Transaction tx, StoredDestination sd, Long messageSequence) throws IOException {
        HashSet<String> hs = new HashSet<String>();
        Iterator<Map.Entry<String, LastAck>> iterator = sd.subscriptionAcks.iterator(tx);
        while (iterator.hasNext()) {
            Map.Entry<String, LastAck> entry = iterator.next();
            hs.add(entry.getKey());
        }
        sd.ackPositions.put(tx, messageSequence, hs);
    }

    private void removeAckLocationsForSub(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        if (!sd.ackPositions.isEmpty(tx)) {
            Long end = sd.ackPositions.getLast(tx).getKey();
            Long sequence = sd.ackPositions.getFirst(tx).getKey();
            while (sequence <= end) {
                this.removeAckLocation(tx, sd, subscriptionKey, sequence);
                Long l = sequence;
                Long l2 = sequence = Long.valueOf(sequence + 1L);
            }
        }
    }

    private void removeAckLocation(Transaction tx, StoredDestination sd, String subscriptionKey, Long sequenceId) throws IOException {
        HashSet<String> hs;
        if (sequenceId != null && (hs = sd.ackPositions.get(tx, sequenceId)) != null) {
            hs.remove(subscriptionKey);
            if (hs.isEmpty()) {
                HashSet<String> firstSet = sd.ackPositions.getFirst(tx).getValue();
                sd.ackPositions.remove(tx, sequenceId);
                ArrayList<Map.Entry<Long, MessageKeys>> deletes = new ArrayList<Map.Entry<Long, MessageKeys>>();
                sd.orderIndex.getDeleteList(tx, deletes, sequenceId);
                for (Map.Entry<Long, MessageKeys> entry : deletes) {
                    sd.locationIndex.remove(tx, entry.getValue().location);
                    sd.messageIdIndex.remove(tx, entry.getValue().messageId);
                    sd.orderIndex.remove(tx, entry.getKey());
                }
            }
        }
    }

    private String key(KahaDestination destination) {
        return destination.getType().getNumber() + ":" + destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Operation> getInflightTx(KahaTransactionInfo info, Location location) {
        List<Operation> tx;
        TransactionId key = this.key(info);
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            tx = this.inflightTransactions.get(key);
            if (tx == null) {
                tx = Collections.synchronizedList(new ArrayList());
                this.inflightTransactions.put(key, tx);
            }
        }
        return tx;
    }

    private TransactionId key(KahaTransactionInfo transactionInfo) {
        if (transactionInfo.hasLocalTransacitonId()) {
            KahaLocalTransactionId tx = transactionInfo.getLocalTransacitonId();
            LocalTransactionId rc = new LocalTransactionId();
            rc.setConnectionId(new ConnectionId(tx.getConnectionId()));
            rc.setValue(tx.getTransacitonId());
            return rc;
        }
        KahaXATransactionId tx = transactionInfo.getXaTransacitonId();
        XATransactionId rc = new XATransactionId();
        rc.setBranchQualifier(tx.getBranchQualifier().toByteArray());
        rc.setGlobalTransactionId(tx.getGlobalTransactionId().toByteArray());
        rc.setFormatId(tx.getFormatId());
        return rc;
    }

    private PageFile createPageFile() {
        PageFile index = new PageFile(this.directory, "db");
        index.setEnableWriteThread(this.isEnableIndexWriteAsync());
        index.setWriteBatchSize(this.getIndexWriteBatchSize());
        index.setPageCacheSize(this.indexCacheSize);
        return index;
    }

    private Journal createJournal() throws IOException {
        Journal manager = new Journal();
        manager.setDirectory(this.directory);
        manager.setMaxFileLength(this.getJournalMaxFileLength());
        manager.setCheckForCorruptionOnStartup(this.checkForCorruptJournalFiles);
        manager.setChecksum(this.checksumJournalFiles || this.checkForCorruptJournalFiles);
        manager.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        manager.setArchiveDataLogs(this.isArchiveDataLogs());
        manager.setSizeAccumulator(this.storeSize);
        if (this.getDirectoryArchive() != null) {
            IOHelper.mkdirs(this.getDirectoryArchive());
            manager.setDirectoryArchive(this.getDirectoryArchive());
        }
        return manager;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isDeleteAllMessages() {
        return this.deleteAllMessages;
    }

    public void setDeleteAllMessages(boolean deleteAllMessages) {
        this.deleteAllMessages = deleteAllMessages;
    }

    public void setIndexWriteBatchSize(int setIndexWriteBatchSize) {
        this.setIndexWriteBatchSize = setIndexWriteBatchSize;
    }

    public int getIndexWriteBatchSize() {
        return this.setIndexWriteBatchSize;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.enableJournalDiskSyncs;
    }

    public void setEnableJournalDiskSyncs(boolean syncWrites) {
        this.enableJournalDiskSyncs = syncWrites;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setMaxFailoverProducersToTrack(int maxFailoverProducersToTrack) {
        this.metadata.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(maxFailoverProducersToTrack);
    }

    public int getMaxFailoverProducersToTrack() {
        return this.metadata.producerSequenceIdTracker.getMaximumNumberOfProducersToTrack();
    }

    public void setFailoverProducersAuditDepth(int failoverProducersAuditDepth) {
        this.metadata.producerSequenceIdTracker.setAuditDepth(failoverProducersAuditDepth);
    }

    public int getFailoverProducersAuditDepth() {
        return this.metadata.producerSequenceIdTracker.getAuditDepth();
    }

    public PageFile getPageFile() {
        if (this.pageFile == null) {
            this.pageFile = this.createPageFile();
        }
        return this.pageFile;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.journal = this.createJournal();
        }
        return this.journal;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.ignoreMissingJournalfiles;
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.ignoreMissingJournalfiles = ignoreMissingJournalfiles;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.checkForCorruptJournalFiles;
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.checkForCorruptJournalFiles = checkForCorruptJournalFiles;
    }

    public boolean isChecksumJournalFiles() {
        return this.checksumJournalFiles;
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.checksumJournalFiles = checksumJournalFiles;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public int getDatabaseLockedWaitDelay() {
        return this.databaseLockedWaitDelay;
    }

    public void setDatabaseLockedWaitDelay(int databaseLockedWaitDelay) {
        this.databaseLockedWaitDelay = databaseLockedWaitDelay;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashSetStringMarshaller
    extends VariableMarshaller<HashSet<String>> {
        static final HashSetStringMarshaller INSTANCE = new HashSetStringMarshaller();

        private HashSetStringMarshaller() {
        }

        @Override
        public void writePayload(HashSet<String> object, DataOutput dataOut) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(object);
            oout.flush();
            oout.close();
            byte[] data = baos.toByteArray();
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }

        @Override
        public HashSet<String> readPayload(DataInput dataIn) throws IOException {
            int dataLen = dataIn.readInt();
            byte[] data = new byte[dataLen];
            dataIn.readFully(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream oin = new ObjectInputStream(bais);
            try {
                return (HashSet)oin.readObject();
            }
            catch (ClassNotFoundException cfe) {
                IOException ioe = new IOException("Failed to read HashSet<String>: " + cfe);
                ioe.initCause(cfe);
                throw ioe;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageOrderIndex {
        static final byte HI = 9;
        static final byte LO = 0;
        static final byte DEF = 4;
        long nextMessageId;
        BTreeIndex<Long, MessageKeys> defaultPriorityIndex;
        BTreeIndex<Long, MessageKeys> lowPriorityIndex;
        BTreeIndex<Long, MessageKeys> highPriorityIndex;
        MessageOrderCursor cursor;
        Long lastDefaultKey;
        Long lastHighKey;
        Long lastLowKey;
        byte lastGetPriority;

        MessageOrderIndex() {
            this.cursor = new MessageOrderCursor();
        }

        MessageKeys remove(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.remove(tx, key);
            if (result == null && this.highPriorityIndex != null && (result = this.highPriorityIndex.remove(tx, key)) == null && this.lowPriorityIndex != null) {
                result = this.lowPriorityIndex.remove(tx, key);
            }
            return result;
        }

        void load(Transaction tx) throws IOException {
            this.defaultPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.defaultPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.defaultPriorityIndex.load(tx);
            this.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.lowPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.lowPriorityIndex.load(tx);
            this.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.highPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.highPriorityIndex.load(tx);
        }

        void allocate(Transaction tx) throws IOException {
            this.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            if (MessageDatabase.this.metadata.version >= 2) {
                this.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                this.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            }
        }

        void configureLast(Transaction tx) throws IOException {
            if (this.highPriorityIndex != null) {
                Map.Entry<Long, MessageKeys> lastEntry = this.highPriorityIndex.getLast(tx);
                if (lastEntry != null) {
                    this.nextMessageId = lastEntry.getKey() + 1L;
                } else {
                    lastEntry = this.defaultPriorityIndex.getLast(tx);
                    if (lastEntry != null) {
                        this.nextMessageId = lastEntry.getKey() + 1L;
                    } else {
                        lastEntry = this.lowPriorityIndex.getLast(tx);
                        if (lastEntry != null) {
                            this.nextMessageId = lastEntry.getKey() + 1L;
                        }
                    }
                }
            } else {
                Map.Entry<Long, MessageKeys> lastEntry = this.defaultPriorityIndex.getLast(tx);
                if (lastEntry != null) {
                    this.nextMessageId = lastEntry.getKey() + 1L;
                }
            }
        }

        void remove(Transaction tx) throws IOException {
            this.defaultPriorityIndex.clear(tx);
            this.defaultPriorityIndex.unload(tx);
            tx.free(this.defaultPriorityIndex.getPageId());
            if (this.lowPriorityIndex != null) {
                this.lowPriorityIndex.clear(tx);
                this.lowPriorityIndex.unload(tx);
                tx.free(this.lowPriorityIndex.getPageId());
            }
            if (this.highPriorityIndex != null) {
                this.highPriorityIndex.clear(tx);
                this.highPriorityIndex.unload(tx);
                tx.free(this.highPriorityIndex.getPageId());
            }
        }

        void resetCursorPosition() {
            this.cursor.reset();
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void setBatch(Transaction tx, Long sequence) throws IOException {
            if (sequence != null) {
                Long nextPosition = new Long(sequence + 1L);
                if (this.defaultPriorityIndex.containsKey(tx, sequence)) {
                    this.lastDefaultKey = nextPosition;
                    this.cursor.defaultCursorPosition = nextPosition;
                } else if (this.highPriorityIndex != null) {
                    if (this.highPriorityIndex.containsKey(tx, sequence)) {
                        this.lastHighKey = nextPosition;
                        this.cursor.highPriorityCursorPosition = nextPosition;
                    } else if (this.lowPriorityIndex.containsKey(tx, sequence)) {
                        this.lastLowKey = nextPosition;
                        this.cursor.lowPriorityCursorPosition = nextPosition;
                    }
                } else {
                    this.lastDefaultKey = nextPosition;
                    this.cursor.defaultCursorPosition = nextPosition;
                }
            }
        }

        void setBatch(Transaction tx, LastAck last) throws IOException {
            this.setBatch(tx, last.lastAckedSequence);
            if (this.cursor.defaultCursorPosition == 0L && this.cursor.highPriorityCursorPosition == 0L && this.cursor.lowPriorityCursorPosition == 0L) {
                long next = last.lastAckedSequence + 1L;
                switch (last.priority) {
                    case 4: {
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 9: {
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 0: {
                        this.cursor.lowPriorityCursorPosition = next;
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                    }
                }
            }
        }

        void stoppedIterating() {
            if (this.lastDefaultKey != null) {
                this.cursor.defaultCursorPosition = this.lastDefaultKey + 1L;
            }
            if (this.lastHighKey != null) {
                this.cursor.highPriorityCursorPosition = this.lastHighKey + 1L;
            }
            if (this.lastLowKey != null) {
                this.cursor.lowPriorityCursorPosition = this.lastLowKey + 1L;
            }
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, Long sequenceId) throws IOException {
            if (this.defaultPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.defaultPriorityIndex, sequenceId);
            } else if (this.highPriorityIndex != null && this.highPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.highPriorityIndex, sequenceId);
            } else if (this.lowPriorityIndex != null && this.lowPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.lowPriorityIndex, sequenceId);
            }
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, BTreeIndex<Long, MessageKeys> index, Long sequenceId) throws IOException {
            Iterator<Map.Entry<Long, MessageKeys>> iterator = index.iterator(tx, sequenceId);
            deletes.add(iterator.next());
        }

        long getNextMessageId(int priority) {
            return this.nextMessageId++;
        }

        MessageKeys get(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.get(tx, key);
            if (result == null) {
                result = this.highPriorityIndex.get(tx, key);
                if (result == null) {
                    result = this.lowPriorityIndex.get(tx, key);
                    this.lastGetPriority = 0;
                } else {
                    this.lastGetPriority = (byte)9;
                }
            } else {
                this.lastGetPriority = (byte)4;
            }
            return result;
        }

        MessageKeys put(Transaction tx, int priority, Long key, MessageKeys value) throws IOException {
            if (priority == 4) {
                return this.defaultPriorityIndex.put(tx, key, value);
            }
            if (priority > 4) {
                return this.highPriorityIndex.put(tx, key, value);
            }
            return this.lowPriorityIndex.put(tx, key, value);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx) throws IOException {
            return new MessageOrderIterator(tx, this.cursor);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx, MessageOrderCursor m) throws IOException {
            return new MessageOrderIterator(tx, m);
        }

        public byte lastGetPriority() {
            return this.lastGetPriority;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MessageOrderIterator
        implements Iterator<Map.Entry<Long, MessageKeys>> {
            Iterator<Map.Entry<Long, MessageKeys>> currentIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> highIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> defaultIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> lowIterator;

            MessageOrderIterator(Transaction tx, MessageOrderCursor m) throws IOException {
                this.defaultIterator = MessageOrderIndex.this.defaultPriorityIndex.iterator(tx, m.defaultCursorPosition);
                this.highIterator = MessageOrderIndex.this.highPriorityIndex != null ? MessageOrderIndex.this.highPriorityIndex.iterator(tx, m.highPriorityCursorPosition) : null;
                this.lowIterator = MessageOrderIndex.this.lowPriorityIndex != null ? MessageOrderIndex.this.lowPriorityIndex.iterator(tx, m.lowPriorityCursorPosition) : null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.highIterator != null) {
                        if (this.highIterator.hasNext()) {
                            this.currentIterator = this.highIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    this.currentIterator = this.defaultIterator;
                    return this.currentIterator.hasNext();
                }
                if (this.highIterator != null) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    if (this.currentIterator == this.highIterator) {
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    if (this.currentIterator == this.defaultIterator) {
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public Map.Entry<Long, MessageKeys> next() {
                Map.Entry<Long, MessageKeys> result = this.currentIterator.next();
                if (result != null) {
                    Long key = result.getKey();
                    if (this.highIterator != null) {
                        if (this.currentIterator == this.defaultIterator) {
                            MessageOrderIndex.this.lastDefaultKey = key;
                        } else if (this.currentIterator == this.highIterator) {
                            MessageOrderIndex.this.lastHighKey = key;
                        } else {
                            MessageOrderIndex.this.lastLowKey = key;
                        }
                    } else {
                        MessageOrderIndex.this.lastDefaultKey = key;
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    class MessageOrderCursor {
        long defaultCursorPosition;
        long lowPriorityCursorPosition;
        long highPriorityCursorPosition;

        MessageOrderCursor() {
        }

        MessageOrderCursor(long position) {
            this.defaultCursorPosition = position;
            this.lowPriorityCursorPosition = position;
            this.highPriorityCursorPosition = position;
        }

        MessageOrderCursor(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }

        MessageOrderCursor copy() {
            return new MessageOrderCursor(this);
        }

        void reset() {
            this.defaultCursorPosition = 0L;
            this.highPriorityCursorPosition = 0L;
            this.lowPriorityCursorPosition = 0L;
        }

        void increment() {
            if (this.defaultCursorPosition != 0L) {
                ++this.defaultCursorPosition;
            }
            if (this.highPriorityCursorPosition != 0L) {
                ++this.highPriorityCursorPosition;
            }
            if (this.lowPriorityCursorPosition != 0L) {
                ++this.lowPriorityCursorPosition;
            }
        }

        public String toString() {
            return "MessageOrderCursor:[def:" + this.defaultCursorPosition + ", low:" + this.lowPriorityCursorPosition + ", high:" + this.highPriorityCursorPosition + "]";
        }

        public void sync(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }
    }

    class RemoveOpperation
    extends Operation {
        final KahaRemoveMessageCommand command;

        public RemoveOpperation(KahaRemoveMessageCommand command, Location location) {
            super(location);
            this.command = command;
        }

        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.updateIndex(tx, this.command, this.location);
        }

        public KahaRemoveMessageCommand getCommand() {
            return this.command;
        }
    }

    class AddOpperation
    extends Operation {
        final KahaAddMessageCommand command;

        public AddOpperation(KahaAddMessageCommand command, Location location) {
            super(location);
            this.command = command;
        }

        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.upadateIndex(tx, this.command, this.location);
        }

        public KahaAddMessageCommand getCommand() {
            return this.command;
        }
    }

    abstract class Operation {
        final Location location;

        public Operation(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public abstract void execute(Transaction var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KahaSubscriptionCommandMarshaller
    extends VariableMarshaller<KahaSubscriptionCommand> {
        static final KahaSubscriptionCommandMarshaller INSTANCE = new KahaSubscriptionCommandMarshaller();

        KahaSubscriptionCommandMarshaller() {
        }

        @Override
        public KahaSubscriptionCommand readPayload(DataInput dataIn) throws IOException {
            KahaSubscriptionCommand rc = new KahaSubscriptionCommand();
            rc.mergeFramed((InputStream)((Object)dataIn));
            return rc;
        }

        @Override
        public void writePayload(KahaSubscriptionCommand object, DataOutput dataOut) throws IOException {
            object.writeFramed((OutputStream)((Object)dataOut));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocationMarshaller
    implements Marshaller<Location> {
        static final LocationMarshaller INSTANCE = new LocationMarshaller();

        LocationMarshaller() {
        }

        @Override
        public Location readPayload(DataInput dataIn) throws IOException {
            Location rc = new Location();
            rc.setDataFileId(dataIn.readInt());
            rc.setOffset(dataIn.readInt());
            return rc;
        }

        @Override
        public void writePayload(Location object, DataOutput dataOut) throws IOException {
            dataOut.writeInt(object.getDataFileId());
            dataOut.writeInt(object.getOffset());
        }

        @Override
        public int getFixedSize() {
            return 8;
        }

        @Override
        public Location deepCopy(Location source) {
            return new Location(source);
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StoredDestinationMarshaller
    extends VariableMarshaller<StoredDestination> {
        protected StoredDestinationMarshaller() {
        }

        @Override
        public StoredDestination readPayload(DataInput dataIn) throws IOException {
            final StoredDestination value = new StoredDestination();
            value.orderIndex.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.locationIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.messageIdIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            if (dataIn.readBoolean()) {
                value.subscriptions = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.subscriptionAcks = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                if (MessageDatabase.this.metadata.version >= 3) {
                    value.ackPositions = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                } else {
                    MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            value.ackPositions = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                            value.ackPositions.setKeyMarshaller(LongMarshaller.INSTANCE);
                            value.ackPositions.setValueMarshaller(HashSetStringMarshaller.INSTANCE);
                            value.ackPositions.load(tx);
                        }
                    });
                }
            }
            if (MessageDatabase.this.metadata.version >= 2) {
                value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            } else {
                MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.lowPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
                        value.orderIndex.lowPriorityIndex.load(tx);
                        value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.highPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
                        value.orderIndex.highPriorityIndex.load(tx);
                    }
                });
            }
            return value;
        }

        @Override
        public void writePayload(StoredDestination value, DataOutput dataOut) throws IOException {
            dataOut.writeLong(value.orderIndex.defaultPriorityIndex.getPageId());
            dataOut.writeLong(value.locationIndex.getPageId());
            dataOut.writeLong(value.messageIdIndex.getPageId());
            if (value.subscriptions != null) {
                dataOut.writeBoolean(true);
                dataOut.writeLong(value.subscriptions.getPageId());
                dataOut.writeLong(value.subscriptionAcks.getPageId());
                dataOut.writeLong(value.ackPositions.getPageId());
            } else {
                dataOut.writeBoolean(false);
            }
            dataOut.writeLong(value.orderIndex.lowPriorityIndex.getPageId());
            dataOut.writeLong(value.orderIndex.highPriorityIndex.getPageId());
        }
    }

    class StoredDestination {
        MessageOrderIndex orderIndex;
        BTreeIndex<Location, Long> locationIndex;
        BTreeIndex<String, Long> messageIdIndex;
        BTreeIndex<String, KahaSubscriptionCommand> subscriptions;
        BTreeIndex<String, LastAck> subscriptionAcks;
        HashMap<String, MessageOrderCursor> subscriptionCursors;
        BTreeIndex<Long, HashSet<String>> ackPositions;

        StoredDestination() {
            this.orderIndex = new MessageOrderIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LastAckMarshaller
    implements Marshaller<LastAck> {
        protected LastAckMarshaller() {
        }

        @Override
        public void writePayload(LastAck object, DataOutput dataOut) throws IOException {
            dataOut.writeLong(object.lastAckedSequence);
            dataOut.writeByte(object.priority);
        }

        @Override
        public LastAck readPayload(DataInput dataIn) throws IOException {
            LastAck lastAcked = new LastAck();
            lastAcked.lastAckedSequence = dataIn.readLong();
            if (MessageDatabase.this.metadata.version >= 3) {
                lastAcked.priority = dataIn.readByte();
            }
            return lastAcked;
        }

        @Override
        public int getFixedSize() {
            return 9;
        }

        @Override
        public LastAck deepCopy(LastAck source) {
            return new LastAck(source);
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }

    class LastAck {
        long lastAckedSequence;
        byte priority;

        public LastAck(LastAck source) {
            this.lastAckedSequence = source.lastAckedSequence;
            this.priority = source.priority;
        }

        public LastAck() {
            this.priority = (byte)9;
        }

        public LastAck(long ackLocation) {
            this.lastAckedSequence = ackLocation;
            this.priority = 0;
        }

        public LastAck(long ackLocation, byte priority) {
            this.lastAckedSequence = ackLocation;
            this.priority = priority;
        }

        public String toString() {
            return "[" + this.lastAckedSequence + ":" + this.priority + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MessageKeysMarshaller
    extends VariableMarshaller<MessageKeys> {
        static final MessageKeysMarshaller INSTANCE = new MessageKeysMarshaller();

        protected MessageKeysMarshaller() {
        }

        @Override
        public MessageKeys readPayload(DataInput dataIn) throws IOException {
            return new MessageKeys(dataIn.readUTF(), LocationMarshaller.INSTANCE.readPayload(dataIn));
        }

        @Override
        public void writePayload(MessageKeys object, DataOutput dataOut) throws IOException {
            dataOut.writeUTF(object.messageId);
            LocationMarshaller.INSTANCE.writePayload(object.location, dataOut);
        }
    }

    static class MessageKeys {
        final String messageId;
        final Location location;

        public MessageKeys(String messageId, Location location) {
            this.messageId = messageId;
            this.location = location;
        }

        public String toString() {
            return "[" + this.messageId + "," + this.location + "]";
        }
    }

    class StoredSubscription {
        SubscriptionInfo subscriptionInfo;
        String lastAckId;
        Location lastAckLocation;
        Location cursor;

        StoredSubscription() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataMarshaller
    extends VariableMarshaller<Metadata> {
        MetadataMarshaller() {
        }

        @Override
        public Metadata readPayload(DataInput dataIn) throws IOException {
            Metadata rc = new Metadata();
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(Metadata object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class Metadata {
        protected Page<Metadata> page;
        protected int state;
        protected BTreeIndex<String, StoredDestination> destinations;
        protected Location lastUpdate;
        protected Location firstInProgressTransactionLocation;
        protected Location producerSequenceIdTrackerLocation = null;
        protected transient ActiveMQMessageAuditNoSync producerSequenceIdTracker = new ActiveMQMessageAuditNoSync();
        protected int version = 3;

        protected Metadata() {
        }

        public void read(DataInput is) throws IOException {
            this.state = is.readInt();
            this.destinations = new BTreeIndex(MessageDatabase.this.pageFile, is.readLong());
            this.lastUpdate = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            this.firstInProgressTransactionLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            try {
                this.producerSequenceIdTrackerLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            }
            catch (EOFException expectedOnUpgrade) {
                // empty catch block
            }
            try {
                this.version = is.readInt();
            }
            catch (EOFException expectedOnUpgrade) {
                this.version = 1;
            }
            LOG.info("KahaDB is version " + this.version);
        }

        public void write(DataOutput os) throws IOException {
            os.writeInt(this.state);
            os.writeLong(this.destinations.getPageId());
            if (this.lastUpdate != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.lastUpdate, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.firstInProgressTransactionLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.firstInProgressTransactionLocation, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.producerSequenceIdTrackerLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.producerSequenceIdTrackerLocation, os);
            } else {
                os.writeBoolean(false);
            }
            os.writeInt(3);
        }
    }
}

