/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.CigarClippingIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

public class CleanSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Read SAM and perform various fix-ups.  " + "Currently, the only fix-up it to soft-clip an alignment that hangs off the end of its reference sequence.";
    @Option(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Option(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] argv) {
        new CleanSam().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.VALIDATION_STRINGENCY == SAMFileReader.ValidationStringency.STRICT) {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.LENIENT);
        }
        SAMFileReader reader = new SAMFileReader(this.INPUT);
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
        CigarClippingIterator it = new CigarClippingIterator((CloseableIterator<SAMRecord>)reader.iterator());
        while (it.hasNext()) {
            writer.addAlignment(it.next());
        }
        writer.close();
        it.close();
        return 0;
    }
}

