/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;

public abstract class AbstractDuplicateFindingAlgorithm
extends CommandLineProgram {
    @Option(doc="Regular expression that can be used to parse read names in the incoming SAM file. Read names are parsed to extract three variables: tile/region, x coordinate and y coordinate. These values are used to estimate the rate of optical duplication in order to give a more accurate estimated library size. The regular expression should contain three capture groups for the three variables, in order.")
    public String READ_NAME_REGEX = "[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*";
    @Option(doc="The maximum offset between two duplicte clusters in order to consider them optical duplicates. This should usually be set to some fairly small number (e.g. 5-10 pixels) unless using later versions of the Illumina pipeline that multiply pixel values by 10, in which case 50-100 is more normal.")
    public int OPTICAL_DUPLICATE_PIXEL_DISTANCE = 100;
    private Pattern READ_NAME_PATTERN = null;

    boolean addLocationInformation(String readName, PhysicalLocation loc) {
        Matcher m;
        if (this.READ_NAME_PATTERN == null) {
            if (this.READ_NAME_REGEX == null) {
                return false;
            }
            this.READ_NAME_PATTERN = Pattern.compile(this.READ_NAME_REGEX);
        }
        if ((m = this.READ_NAME_PATTERN.matcher(readName)).matches()) {
            loc.setTile((byte)Integer.parseInt(m.group(1)));
            loc.setX((short)Integer.parseInt(m.group(2)));
            loc.setY((short)Integer.parseInt(m.group(3)));
            return true;
        }
        return false;
    }

    boolean[] findOpticalDuplicates(List<? extends PhysicalLocation> list, int maxDistance) {
        int length = list.size();
        boolean[] opticalDuplicateFlags = new boolean[length];
        Collections.sort(list, new Comparator<PhysicalLocation>(){

            @Override
            public int compare(PhysicalLocation lhs, PhysicalLocation rhs) {
                int retval = lhs.getReadGroup() - rhs.getReadGroup();
                if (retval == 0) {
                    retval = lhs.getTile() - rhs.getTile();
                }
                if (retval == 0) {
                    retval = lhs.getX() - rhs.getX();
                }
                if (retval == 0) {
                    retval = lhs.getY() - rhs.getY();
                }
                return retval;
            }
        });
        block0: for (int i = 0; i < length; ++i) {
            PhysicalLocation lhs = list.get(i);
            if (lhs.getTile() < 0) continue;
            for (int j = i + 1; j < length; ++j) {
                PhysicalLocation rhs = list.get(j);
                if (lhs.getReadGroup() != rhs.getReadGroup() || lhs.getTile() != rhs.getTile() || rhs.getX() > lhs.getX() + maxDistance) continue block0;
                if (Math.abs(lhs.getY() - rhs.getY()) > maxDistance) continue;
                opticalDuplicateFlags[j] = true;
            }
        }
        return opticalDuplicateFlags;
    }

    public static interface PhysicalLocation {
        public short getReadGroup();

        public void setReadGroup(short var1);

        public byte getTile();

        public void setTile(byte var1);

        public short getX();

        public void setX(short var1);

        public short getY();

        public void setY(short var1);
    }
}

