/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.AsciiLineReader;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.StringUtil;

class SAMTextReader
extends SAMFileReader.ReaderImplementation {
    private static final int QNAME_COL = 0;
    private static final int FLAG_COL = 1;
    private static final int RNAME_COL = 2;
    private static final int POS_COL = 3;
    private static final int MAPQ_COL = 4;
    private static final int CIGAR_COL = 5;
    private static final int MRNM_COL = 6;
    private static final int MPOS_COL = 7;
    private static final int ISIZE_COL = 8;
    private static final int SEQ_COL = 9;
    private static final int QUAL_COL = 10;
    private static final int NUM_REQUIRED_FIELDS = 11;
    private static final Pattern VALID_BASES = Pattern.compile("^[acgtnACGTN.=]+$");
    private AsciiLineReader mReader;
    private SAMFileHeader mFileHeader = null;
    private String mCurrentLine = null;
    private RecordIterator mIterator = null;
    private File mFile = null;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;
    private SAMFileReader mParentReader;

    SAMTextReader(InputStream stream, SAMFileReader.ValidationStringency validationStringency) {
        this.mReader = new AsciiLineReader(stream);
        this.validationStringency = validationStringency;
        this.readHeader();
    }

    SAMTextReader(InputStream stream, File file, SAMFileReader.ValidationStringency validationStringency) {
        this(stream, validationStringency);
        this.mFile = file;
    }

    @Override
    void enableFileSource(SAMFileReader reader, boolean enabled) {
        this.mParentReader = enabled ? reader : null;
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        throw new UnsupportedOperationException("Cannot enable index caching for a SAM text reader");
    }

    @Override
    void enableCrcChecking(boolean enabled) {
    }

    @Override
    boolean hasIndex() {
        return false;
    }

    @Override
    BAMIndex getIndex() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            finally {
                this.mReader = null;
            }
        }
    }

    @Override
    SAMFileHeader getFileHeader() {
        return this.mFileHeader;
    }

    @Override
    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public void setValidationStringency(SAMFileReader.ValidationStringency stringency) {
        this.validationStringency = stringency;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator() {
        if (this.mReader == null) {
            throw new IllegalStateException("File reader is closed");
        }
        if (this.mIterator != null) {
            throw new IllegalStateException("Iteration in progress");
        }
        this.mIterator = new RecordIterator();
        return this.mIterator;
    }

    @Override
    CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        throw new UnsupportedOperationException("Cannot directly iterate over regions within SAM text files.");
    }

    @Override
    SAMFileSpan getFilePointerSpanningReads() {
        throw new UnsupportedOperationException("Cannot retrieve file pointers within SAM text files.");
    }

    @Override
    CloseableIterator<SAMRecord> query(String sequence, int start, int end, boolean contained) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        throw new UnsupportedOperationException("Cannot query SAM text files");
    }

    private void readHeader() {
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        headerCodec.setValidationStringency(this.validationStringency);
        this.mFileHeader = headerCodec.decode(this.mReader, this.mFile != null ? this.mFile.toString() : null);
        this.advanceLine();
    }

    private String advanceLine() {
        this.mCurrentLine = this.mReader.readLine();
        return this.mCurrentLine;
    }

    private String makeErrorString(String reason) {
        String fileMessage = "";
        if (this.mFile != null) {
            fileMessage = "File " + this.mFile + "; ";
        }
        return "Error parsing text SAM file. " + reason + "; " + fileMessage + "Line " + this.mReader.getLineNumber() + "\nLine: " + this.mCurrentLine;
    }

    private RuntimeException reportFatalErrorParsingLine(String reason) {
        return new SAMFormatException(this.makeErrorString(reason));
    }

    private void reportErrorParsingLine(String reason) {
        String errorMessage = this.makeErrorString(reason);
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    private void reportErrorParsingLine(Exception e) {
        String errorMessage = this.makeErrorString(e.getMessage());
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException(errorMessage);
        }
        if (this.validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error due to lenient parsing:");
            System.err.println(errorMessage);
        }
    }

    private class RecordIterator
    implements CloseableIterator<SAMRecord> {
        private final String[] mFields = new String[10000];

        private RecordIterator() {
            if (SAMTextReader.this.mReader == null) {
                throw new IllegalStateException("Reader is closed.");
            }
        }

        @Override
        public void close() {
            SAMTextReader.this.close();
        }

        @Override
        public boolean hasNext() {
            return SAMTextReader.this.mCurrentLine != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAMRecord next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("Cannot call next() on exhausted iterator");
            }
            try {
                SAMRecord sAMRecord = this.parseLine();
                return sAMRecord;
            }
            finally {
                SAMTextReader.this.advanceLine();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported: remove");
        }

        int parseInt(String s, String fieldName) {
            int ret;
            try {
                ret = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw SAMTextReader.this.reportFatalErrorParsingLine("Non-numeric value in " + fieldName + " column");
            }
            return ret;
        }

        void validateReferenceName(String rname, String fieldName) {
            if (rname.equals("=")) {
                if (fieldName.equals("MRNM")) {
                    return;
                }
                SAMTextReader.this.reportErrorParsingLine("= is not a valid value for " + fieldName + " field.");
            }
            if (SAMTextReader.this.getFileHeader().getSequenceDictionary().size() != 0 && SAMTextReader.this.getFileHeader().getSequence(rname) == null) {
                SAMTextReader.this.reportErrorParsingLine(fieldName + " '" + rname + "' not found in any SQ record");
            }
        }

        private SAMRecord parseLine() {
            int numFields = StringUtil.split(SAMTextReader.this.mCurrentLine, this.mFields, '\t');
            if (numFields < 11) {
                throw SAMTextReader.this.reportFatalErrorParsingLine("Not enough fields");
            }
            if (numFields == this.mFields.length) {
                SAMTextReader.this.reportErrorParsingLine("Too many fields in SAM text record.");
            }
            for (int i = 0; i < numFields; ++i) {
                if (this.mFields[i].length() != 0) continue;
                SAMTextReader.this.reportErrorParsingLine("Empty field at position " + i + " (zero-based)");
            }
            SAMRecord samRecord = new SAMRecord(SAMTextReader.this.mFileHeader);
            samRecord.setValidationStringency(SAMTextReader.this.getValidationStringency());
            if (SAMTextReader.this.mParentReader != null) {
                samRecord.setFileSource(new SAMFileSource(SAMTextReader.this.mParentReader, null));
            }
            samRecord.setHeader(SAMTextReader.this.mFileHeader);
            samRecord.setReadName(this.mFields[0]);
            int flags = this.parseInt(this.mFields[1], "FLAG");
            samRecord.setFlags(flags);
            String rname = this.mFields[2];
            if (!rname.equals("*")) {
                rname = SAMSequenceRecord.truncateSequenceName(rname);
                this.validateReferenceName(rname, "RNAME");
                samRecord.setReferenceName(rname);
            } else if (!samRecord.getReadUnmappedFlag()) {
                SAMTextReader.this.reportErrorParsingLine("RNAME is not specified but flags indicate mapped");
            }
            int pos = this.parseInt(this.mFields[3], "POS");
            int mapq = this.parseInt(this.mFields[4], "MAPQ");
            String cigar = this.mFields[5];
            if (!"*".equals(samRecord.getReferenceName())) {
                if (pos == 0) {
                    SAMTextReader.this.reportErrorParsingLine("POS must be non-zero if RNAME is specified");
                }
                if (!samRecord.getReadUnmappedFlag() && cigar.equals("*")) {
                    SAMTextReader.this.reportErrorParsingLine("CIGAR must not be '*' if RNAME is specified");
                }
            } else {
                if (pos != 0) {
                    SAMTextReader.this.reportErrorParsingLine("POS must be zero if RNAME is not specified");
                }
                if (mapq != 0) {
                    SAMTextReader.this.reportErrorParsingLine("MAPQ must be zero if RNAME is not specified");
                }
                if (!cigar.equals("*")) {
                    SAMTextReader.this.reportErrorParsingLine("CIGAR must be '*' if RNAME is not specified");
                }
            }
            samRecord.setAlignmentStart(pos);
            samRecord.setMappingQuality(mapq);
            samRecord.setCigarString(cigar);
            String mateRName = this.mFields[6];
            if (mateRName.equals("*")) {
                if (samRecord.getReadPairedFlag() && !samRecord.getMateUnmappedFlag()) {
                    SAMTextReader.this.reportErrorParsingLine("MRNM not specified but flags indicate mate mapped");
                }
            } else {
                if (!samRecord.getReadPairedFlag()) {
                    SAMTextReader.this.reportErrorParsingLine("MRNM specified but flags indicate unpaired");
                }
                if (!"=".equals(mateRName)) {
                    mateRName = SAMSequenceRecord.truncateSequenceName(mateRName);
                }
                this.validateReferenceName(mateRName, "MRNM");
                if (mateRName.equals("=")) {
                    if (samRecord.getReferenceName() == null) {
                        SAMTextReader.this.reportErrorParsingLine("MRNM is '=', but RNAME is not set");
                    }
                    samRecord.setMateReferenceName(samRecord.getReferenceName());
                } else {
                    samRecord.setMateReferenceName(mateRName);
                }
            }
            int matePos = this.parseInt(this.mFields[7], "MPOS");
            int isize = this.parseInt(this.mFields[8], "ISIZE");
            if (!samRecord.getMateReferenceName().equals("*")) {
                if (matePos == 0) {
                    SAMTextReader.this.reportErrorParsingLine("MPOS must be non-zero if MRNM is specified");
                }
            } else {
                if (matePos != 0) {
                    SAMTextReader.this.reportErrorParsingLine("MPOS must be zero if MRNM is not specified");
                }
                if (isize != 0) {
                    SAMTextReader.this.reportErrorParsingLine("ISIZE must be zero if MRNM is not specified");
                }
            }
            samRecord.setMateAlignmentStart(matePos);
            samRecord.setInferredInsertSize(isize);
            if (!this.mFields[9].equals("*")) {
                this.validateReadBases(this.mFields[9]);
                samRecord.setReadString(this.mFields[9]);
            } else {
                samRecord.setReadBases(SAMRecord.NULL_SEQUENCE);
            }
            if (!this.mFields[10].equals("*")) {
                if (samRecord.getReadBases() == SAMRecord.NULL_SEQUENCE) {
                    SAMTextReader.this.reportErrorParsingLine("QUAL should not be specified if SEQ is not specified");
                }
                if (samRecord.getReadString().length() != this.mFields[10].length()) {
                    SAMTextReader.this.reportErrorParsingLine("length(QUAL) != length(SEQ)");
                }
                samRecord.setBaseQualityString(this.mFields[10]);
            } else {
                samRecord.setBaseQualities(SAMRecord.NULL_QUALS);
            }
            for (int i = 11; i < numFields; ++i) {
                this.parseTag(samRecord, this.mFields[i]);
            }
            List<SAMValidationError> validationErrors = samRecord.isValid();
            if (validationErrors != null) {
                for (SAMValidationError errorMessage : validationErrors) {
                    SAMTextReader.this.reportErrorParsingLine(errorMessage.getMessage());
                }
            }
            return samRecord;
        }

        private void validateReadBases(String bases) {
            if (!VALID_BASES.matcher(bases).matches()) {
                SAMTextReader.this.reportErrorParsingLine("Invalid character in read bases");
            }
        }

        private void parseTag(SAMRecord samRecord, String tag) {
            Map.Entry<String, Object> entry = null;
            try {
                entry = SAMTextReader.this.tagCodec.decode(tag);
            }
            catch (SAMFormatException e) {
                SAMTextReader.this.reportErrorParsingLine(e);
            }
            if (entry != null) {
                samRecord.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }
}

