/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.pool.PooledSession;
import org.apache.activemq.pool.SessionKey;
import org.apache.activemq.pool.SessionPool;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.pool.ObjectPoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool {
    private ActiveMQConnection connection;
    private Map<SessionKey, SessionPool> cache;
    private AtomicBoolean started = new AtomicBoolean(false);
    private int referenceCount;
    private ObjectPoolFactory poolFactory;
    private long lastUsed;
    private long firstUsed = this.lastUsed = System.currentTimeMillis();
    private boolean hasFailed;
    private boolean hasExpired;
    private int idleTimeout = 30000;
    private long expiryTimeout = 0L;

    public ConnectionPool(ActiveMQConnection connection, ObjectPoolFactory poolFactory) {
        this(connection, new HashMap<SessionKey, SessionPool>(), poolFactory);
        connection.addTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(IOException error) {
                ConnectionPool connectionPool = ConnectionPool.this;
                synchronized (connectionPool) {
                    ConnectionPool.this.hasFailed = true;
                }
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        if (connection.isTransportFailed()) {
            this.hasFailed = true;
        }
    }

    public ConnectionPool(ActiveMQConnection connection, Map<SessionKey, SessionPool> cache, ObjectPoolFactory poolFactory) {
        this.connection = connection;
        this.cache = cache;
        this.poolFactory = poolFactory;
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized ActiveMQConnection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        SessionKey key = new SessionKey(transacted, ackMode);
        SessionPool pool = this.cache.get(key);
        if (pool == null) {
            pool = this.createSessionPool(key);
            this.cache.put(key, pool);
        }
        PooledSession session = pool.borrowSession();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                Iterator<SessionPool> i = this.cache.values().iterator();
                while (i.hasNext()) {
                    SessionPool pool = i.next();
                    i.remove();
                    try {
                        pool.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired) {
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        if (this.hasFailed || this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout || this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
            }
            return true;
        }
        return false;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected SessionPool createSessionPool(SessionKey key) {
        return new SessionPool(this, key, this.poolFactory.createPool());
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }
}

