/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultPollingConsumerPollStrategy;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable,
SuspendableService {
    private static final transient Log LOG = LogFactory.getLog(ScheduledPollConsumer.class);
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay;
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();
    private volatile boolean suspended;

    public ScheduledPollConsumer(DefaultEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.executor = endpoint.getCamelContext().getExecutorServiceStrategy().newScheduledThreadPool(this, endpoint.getEndpointUri(), 1);
        ObjectHelper.notNull(this.executor, "executor");
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor);
        this.executor = executor;
        ObjectHelper.notNull(executor, "executor");
    }

    public void run() {
        if (this.suspended) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cannot start to poll: " + this.getEndpoint() + " as its suspended"));
            }
            return;
        }
        int retryCounter = -1;
        boolean done = false;
        while (!done) {
            try {
                done = true;
                if (this.isPollAllowed()) {
                    boolean begin;
                    if (retryCounter == -1) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Starting to poll: " + this.getEndpoint()));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Retrying attempt " + retryCounter + " to poll: " + this.getEndpoint()));
                    }
                    if (begin = this.pollStrategy.begin(this, this.getEndpoint())) {
                        ++retryCounter;
                        this.poll();
                        this.pollStrategy.commit(this, this.getEndpoint());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cannot begin polling as pollStrategy returned false: " + this.pollStrategy));
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Finished polling: " + this.getEndpoint()));
            }
            catch (Exception e) {
                try {
                    boolean retry = this.pollStrategy.rollback(this, this.getEndpoint(), retryCounter, e);
                    if (!retry) continue;
                    done = false;
                }
                catch (Exception re) {
                    throw ObjectHelper.wrapRuntimeCamelException(re);
                }
            }
            catch (Error e) {
                this.log.fatal((Object)("Consumer " + this + " could not poll endpoint: " + this.getEndpoint().getEndpointUri() + " caused by: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
    }

    protected boolean isPollAllowed() {
        return this.isRunAllowed() && !this.isSuspended();
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    protected abstract void poll() throws Exception;

    protected void doStart() throws Exception {
        super.doStart();
        this.future = this.isUseFixedDelay() ? this.executor.scheduleWithFixedDelay(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit()) : this.executor.scheduleAtFixedRate(this, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
    }

    protected void doStop() throws Exception {
        if (this.future != null) {
            this.future.cancel(false);
        }
        super.doStop();
    }
}

