/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static synchronized XmlUtil getInstance() {
        return new XmlUtil();
    }

    public static Document newDocument() throws ParserConfigurationException {
        return XmlUtil.newDocumentBuilder().newDocument();
    }

    public static Document parseFile(File file) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtil.newDocumentBuilder().parse(file);
    }

    public static Document parseReader(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return XmlUtil.newDocumentBuilder().parse(new InputSource(reader));
    }

    public static void printXml(Document xml, Writer out) throws TransformerException, UnsupportedEncodingException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(xml), new StreamResult(out));
    }

    public static Element getChildWithAttributeValue(Element parent, String attrName, String attrValue) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !attrValue.equals((element = (Element)node).getAttribute(attrName))) continue;
            return element;
        }
        return null;
    }

    public static Element getChildWithAttribute(Element parent, String attrName) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || "".equals((element = (Element)node).getAttribute(attrName))) continue;
            return element;
        }
        return null;
    }

    public static void printXml(Document response, OutputStream out) throws UnsupportedEncodingException, TransformerException {
        XmlUtil.printXml(response, new OutputStreamWriter(out));
    }

    public static List<Element> getChildElements(Element parent) {
        return XmlUtil.getChildElements(parent, null);
    }

    public static List<Element> getChildElements(Element parent, String name) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)childNodes.item(i);
            if (name != null && !childElement.getLocalName().equals(name)) continue;
            childElements.add(childElement);
        }
        return childElements;
    }

    public static Element getChildElement(Element parent, String name) {
        return XmlUtil.getChildElement(parent, name, false);
    }

    public static Element getChildElement(Element parent, String name, boolean strict) {
        List<Element> childElements = XmlUtil.getChildElements(parent, name);
        if (strict && childElements.size() != 1) {
            throw new IllegalArgumentException("parent must contain exactly one element with the given name");
        }
        return childElements.isEmpty() ? null : childElements.get(0);
    }

    private static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Document stringToXML(String xml) {
        try {
            return XmlUtil.parseReader(new StringReader(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

