/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerException;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.MessagingTestBase;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.jms.JMSException;
import org.testng.Assert;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class FileBrokerClientTest
extends MessagingTestBase {
    private FileBrokerClient fbc;

    @Override
    @BeforeSuite(alwaysRun=true)
    protected void setUp() throws Exception {
        super.setUp();
        this.fbc = new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE));
    }

    @Override
    @AfterSuite(alwaysRun=true)
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testFileBroker() throws FileNotFoundException, FileBrokerException, JMSException, IOException {
        File file = new File("src/test/resources/affy_example.cel");
        System.out.println("Adding file");
        URL url = this.fbc.addFile(new FileInputStream(file), file.length(), null);
        System.out.println("Checking file");
        Assert.assertTrue((boolean)this.fbc.checkFile(url, file.length()));
        System.out.println("Getting file");
        long outputContentLength = 0L;
        BufferedInputStream input = new BufferedInputStream(this.fbc.getFile(url));
        while (input.read() != -1) {
            ++outputContentLength;
        }
        IOUtils.closeIfPossible(input);
        Assert.assertEquals((long)file.length(), (long)outputContentLength);
    }
}

