/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.workflow;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.parameter.DataSelectionParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.databeans.DataBean;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class WorkflowWriter {
    private LinkedList<String> writeWarnings = new LinkedList();
    private HashMap<DataBean, String> resultIdMap;
    private boolean used = false;

    public static String generateVersionHeaderLine() {
        return "// VERSION BSH/2 (do not remove this)\n";
    }

    public synchronized StringBuffer writeWorkflow(DataBean root) throws IOException {
        if (this.used) {
            throw new IllegalStateException("writer cannot be reused");
        }
        this.resultIdMap = new HashMap();
        StringBuffer script = new StringBuffer("");
        this.generateHeader(script, root);
        this.generateRecursively(script, root);
        this.used = true;
        return script;
    }

    private void generateRecursively(StringBuffer script, DataBean bean) {
        HashSet<OperationRecord> operationRecords = new HashSet<OperationRecord>();
        for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
            operationRecords.add(derived.getOperationRecord());
        }
        for (OperationRecord operationRecord : operationRecords) {
            LinkedList<DataBean> results = new LinkedList<DataBean>();
            for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
                if (derived.getOperationRecord() != operationRecord) continue;
                results.add(derived);
            }
            this.generateStep(script, operationRecord, results);
        }
        for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
            this.generateRecursively(script, derived);
        }
    }

    private void generateStep(StringBuffer script, OperationRecord operationRecord, LinkedList<DataBean> results) {
        OperationDefinition toolDefinition = Session.getSession().getApplication().getOperationDefinition(operationRecord.getNameID().getID());
        if (toolDefinition == null) {
            // empty if block
        }
        StringBuffer dataString = new StringBuffer("\ndatas = new WfDataBean[] {\n");
        boolean first = true;
        for (OperationRecord.InputRecord inputRecord : operationRecord.getInputs()) {
            if (inputRecord.getNameID().getID().equals("phenodata.tsv")) continue;
            if (!first) {
                dataString.append(",\n");
            } else {
                first = false;
            }
            String name = this.resultIdMap.get(inputRecord.getValue());
            if (name == null) {
                this.writeWarnings.add("Tool " + operationRecord.getFullName() + " was skipped because it combines multiple workflow branches.");
                return;
            }
            dataString.append("  " + name);
        }
        dataString.append("\n};\n");
        script.append(dataString);
        script.append("op = new WfOperation(app.getOperationDefinition(\"" + operationRecord.getNameID().getID() + "\"), datas);\n");
        for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
            Parameter parameter;
            if (parameterRecord.getValue() == null || parameterRecord.getValue().equals("") || (parameter = (Parameter)toolDefinition.getParameter(parameterRecord.getNameID().getID()).clone()) == null) continue;
            if (parameter instanceof DataSelectionParameter) {
                ((DataSelectionParameter)parameter).parseValueAndSetWithoutChecks(parameterRecord.getValue());
            } else {
                parameter.parseValue(parameterRecord.getValue());
            }
            script.append("op.setParameter(\"" + parameter.getID() + "\", " + parameter.getValueAsJava() + ");\n");
        }
        script.append("opBlocker = new WfResultBlocker();\n");
        script.append("op.setResultListener(opBlocker);\n");
        script.append("app.executeOperation(op);\n");
        script.append("opBlocker.blockUntilDone();\n");
        int i = -1;
        for (DataBean result : results) {
            String name = "data" + this.resultIdMap.size();
            this.resultIdMap.put(result, name);
            script.append(name + " = opBlocker.getWorkflowResults().get(" + ++i + ");\n");
        }
    }

    private void generateHeader(StringBuffer script, DataBean root) {
        script.append(WorkflowWriter.generateVersionHeaderLine());
        script.append("/* \n  BeanShell workflow script for " + ApplicationConstants.TITLE + "\n" + "  Generated by " + System.getProperty("user.name") + " at " + new Date().toString() + "\n" + "*/\n");
        script.append("\n");
        script.append("import fi.csc.microarray.client.workflow.api.*;\n");
        script.append("\n");
        script.append("data0 = app.getSelectionManager().getSelectedDataBean();\n");
        this.resultIdMap.put(root, "data0");
    }

    public List<String> writeWarnings() {
        return this.writeWarnings;
    }
}

