/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TranscriptTrack
extends Track {
    private Map<String, Gene> genes = new TreeMap<String, Gene>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private Color color;
    private long maxBpLength;

    public TranscriptTrack(View view, DataSource file, Class<? extends AreaRequestHandler> handler, Color color, long maxBpLength) {
        super(view, file, handler);
        this.color = color;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.genes != null) {
            ArrayList<Gene> sortedGenes = new ArrayList<Gene>(this.genes.values());
            Collections.sort(sortedGenes);
            for (Gene gene : sortedGenes) {
                int i;
                if (!gene.region.intersects(this.getView().getBpRegion())) {
                    this.genes.remove(gene.id);
                    continue;
                }
                Rectangle rect = new Rectangle();
                int x = rect.x = this.getView().bpToTrack(gene.region.start).intValue();
                rect.width = this.getView().bpToTrack(gene.region.end) - rect.x;
                int x2 = this.getView().bpToTrack(gene.region.end);
                for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x; ++i) {
                }
                int end = rect.x + rect.width;
                if (this.occupiedSpace.size() > i) {
                    this.occupiedSpace.set(i, end);
                } else {
                    this.occupiedSpace.add(end);
                }
                rect.y = (i + 1) * 14;
                int y = rect.y + 2;
                rect.height = 2;
                drawables.add(new LineDrawable(x, y, x2, y, Color.darkGray));
                rect.height = 4;
                if (((RegionContent)gene.first()).values.get((Object)ColumnType.STRAND) == Strand.REVERSED) {
                    drawables.addAll(this.getArrowDrawables(rect.x, rect.y, -rect.height, rect.height));
                } else {
                    drawables.addAll(this.getArrowDrawables(rect.x + rect.width, rect.y, rect.height, rect.height));
                }
                String geneId = (String)((RegionContent)gene.first()).values.get((Object)ColumnType.DESCRIPTION);
                if (this.isNameVisible(rect)) {
                    this.drawTextAboveRectangle(geneId, drawables, rect, 1);
                }
                ArrayList<RectDrawable> geneDrawables = new ArrayList<RectDrawable>();
                for (RegionContent part : gene) {
                    Color c;
                    if (part.values == null) {
                        drawables.add(this.createDrawable(part.region.start, part.region.end, this.color));
                        continue;
                    }
                    String value = ((String)part.values.get((Object)ColumnType.VALUE)).trim();
                    if (value.equals("CDS")) {
                        c = PartColor.CDS.c;
                    } else if (value.equals("exon")) {
                        c = PartColor.UTR.c;
                    } else if (value.contains("start_codon")) {
                        c = PartColor.START_CODON.c;
                    } else if (value.equals("stop_codon")) {
                        c = PartColor.UTR.c;
                    } else {
                        System.out.println("Gene description not recognised: " + value);
                        c = Color.blue;
                    }
                    rect.x = this.getView().bpToTrack(part.region.start);
                    rect.width = this.getView().bpToTrack(part.region.end) - rect.x;
                    rect.height = 4;
                    geneDrawables.add(new RectDrawable(rect, c, null));
                }
                Collections.sort(geneDrawables, new Comparator<Drawable>(){

                    @Override
                    public int compare(Drawable one, Drawable other) {
                        if (one.color.equals(PartColor.CDS.c) && other.color.equals(PartColor.UTR.c)) {
                            return 1;
                        }
                        if (one.color.equals(PartColor.UTR.c) && other.color.equals(PartColor.CDS.c)) {
                            return -1;
                        }
                        return 0;
                    }
                });
                drawables.addAll(geneDrawables);
            }
        }
        return drawables;
    }

    private Drawable createDrawable(BpCoord startBp, BpCoord endBp, Color c) {
        return this.createDrawable(startBp, endBp, 5, c);
    }

    private Drawable createDrawable(BpCoord startBp, BpCoord endBp, int height, Color c) {
        int i;
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
        }
        int end = rect.x + rect.width;
        if (this.occupiedSpace.size() > i) {
            this.occupiedSpace.set(i, end);
        } else {
            this.occupiedSpace.add(end);
        }
        rect.y = (i + 1) * (height + 2);
        rect.height = height;
        return new RectDrawable(rect, c, null);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (areaResult.getStatus().concise || content.values.get((Object)ColumnType.STRAND) != this.getStrand()) continue;
            LinkedHashMap<ColumnType, Object> values = content.values;
            String id = (String)values.get((Object)ColumnType.PARENT_ID);
            if (!this.genes.containsKey(id)) {
                this.genes.put(id, new Gene(new BpCoordRegion((Long)values.get((Object)ColumnType.PARENT_BP_START), (Long)values.get((Object)ColumnType.PARENT_BP_END), (Chromosome)values.get((Object)ColumnType.CHROMOSOME)), id));
            }
            this.genes.get(id).add(content);
            this.getView().redraw();
        }
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.CHROMOSOME, ColumnType.PARENT_BP_START, ColumnType.PARENT_BP_END, ColumnType.STRAND, ColumnType.DESCRIPTION, ColumnType.VALUE, ColumnType.PARENT_ID, ColumnType.PARENT_PART)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    public static enum PartColor {
        CDS(VisualConstants.COLOR_BLUE),
        UTR(VisualConstants.COLOR_ORANGE),
        START_CODON(Color.gray);

        public Color c;

        private PartColor(Color c) {
            this.c = c;
        }
    }
}

