/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class Track
implements AreaResultListener {
    private static final int NAME_VISIBLE_VIEW_RATIO = 20;
    protected View view;
    protected DataSource file;
    protected Strand strand = Strand.FORWARD;
    protected Integer height;
    protected boolean visible = true;
    private Point2D[] arrowPoints = new Point2D[]{new Point2D.Double(0.0, 0.25), new Point2D.Double(0.5, 0.25), new Point2D.Double(0.5, 0.0), new Point2D.Double(1.0, 0.5), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, 0.75), new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.25)};

    public Track(View view, DataSource file) {
        this.view = view;
        this.file = file;
    }

    public Track(View view, DataSource file, Class<? extends AreaRequestHandler> handler) {
        this(view, file);
        view.getQueueManager().createQueue(file, handler);
    }

    public void initializeListener() {
        if (this.file == null) {
            throw new RuntimeException("Track has no file: " + this);
        }
        this.view.getQueueManager().addResultListener(this.file, this);
    }

    public abstract Collection<Drawable> getDrawables();

    protected View getView() {
        return this.view;
    }

    public boolean hasData() {
        return this.file != null;
    }

    public abstract Map<DataSource, Set<ColumnType>> requestedData();

    public abstract boolean isConcised();

    public Collection<Drawable> getEmptyDrawCollection() {
        return new LinkedList<Drawable>();
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public abstract boolean isStretchable();

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setStrand(Strand s) {
        this.strand = s;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public boolean isReversed() {
        return this.strand == Strand.REVERSED;
    }

    public boolean canExpandDrawables() {
        return false;
    }

    protected Collection<? extends Drawable> getArrowDrawables(int x, int y, int width, int height) {
        Collection<Drawable> parts = this.getEmptyDrawCollection();
        for (int i = 1; i < this.arrowPoints.length; ++i) {
            Point2D p1 = this.arrowPoints[i - 1];
            Point2D p2 = this.arrowPoints[i];
            Point2D.Double p1Scaled = new Point2D.Double((double)x + p1.getX() * (double)width, (double)y + p1.getY() * (double)height);
            Point2D.Double p2Scaled = new Point2D.Double((double)x + p2.getX() * (double)width, (double)y + p2.getY() * (double)height);
            parts.add(new LineDrawable((int)((Point2D)p1Scaled).getX(), (int)((Point2D)p1Scaled).getY(), (int)((Point2D)p2Scaled).getX(), (int)((Point2D)p2Scaled).getY(), Color.black));
        }
        return parts;
    }

    public BpCoord getMaxBp(Chromosome chr) {
        return null;
    }

    public String getName() {
        return "Track";
    }

    public boolean isNameVisible(Rectangle rect) {
        return rect.width > this.getView().getWidth() / 20;
    }

    protected void drawTextAboveRectangle(String text, Collection<Drawable> drawables, Rectangle rect, int offset) {
        drawables.add(new TextDrawable(rect.x < 0 ? 0 : rect.x, rect.y + offset, text, Color.DARK_GRAY));
    }
}

