/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class IntensityTrack
extends Track {
    public static final int SAMPLING_GRANULARITY = 100;
    private SortedSet<RegionContent> values = new TreeSet<RegionContent>();
    private LinkedList<RegionContent> valueStorageOrder = new LinkedList();
    private long minBpLength;
    private Color color;
    private boolean doLog;
    private boolean removeTooWide;

    public IntensityTrack(View view, DataSource file, Class<? extends AreaRequestHandler> handler, Color c, long maxBpLength, boolean doLog, boolean removeTooWide) {
        super(view, file, handler);
        this.color = c;
        this.doLog = doLog;
        this.minBpLength = maxBpLength;
        this.removeTooWide = removeTooWide;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            RegionContent regCont = (RegionContent)iterator.next();
            if (!regCont.region.intersects(this.getView().getBpRegion())) {
                iterator.remove();
                continue;
            }
            if (this.removeTooWide && regCont.region.getLength() > this.getView().getBpRegion().getLength() / 100L * 2L) {
                iterator.remove();
                continue;
            }
            int x1 = this.getView().bpToTrack(regCont.region.start);
            int x2 = this.getView().bpToTrack(regCont.region.end) + 2;
            int y = 0;
            double count = ((Float)regCont.values.get((Object)ColumnType.VALUE)).floatValue();
            if (this.doLog) {
                count = Math.log(count);
            }
            int height = (int)Math.min(count * 6.0, (double)this.getView().getTrackHeight());
            drawables.add(new RectDrawable(x1, y, x2 - x1, height, this.color, null));
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (areaResult.getStatus().concise != this.isConcised() || content.values.get((Object)ColumnType.STRAND) != this.getStrand() || content.values.get((Object)ColumnType.VALUE) == null || !content.region.intersects(this.getView().getBpRegion())) continue;
            this.values.add(content);
            this.valueStorageOrder.add(content);
        }
        this.getView().redraw();
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet());
        return datas;
    }

    @Override
    public boolean isConcised() {
        return true;
    }
}

