/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CoverageTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private Color forwardColor;
    private Color backwardColor;
    private ReadpartDataProvider readpartProvider;

    public CoverageTrack(View view, DataSource file, ReadpartDataProvider readpartProvider, Class<? extends AreaRequestHandler> handler, Color forwardColor, Color backwardColor, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.forwardColor = forwardColor;
        this.backwardColor = backwardColor;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.readpartProvider = readpartProvider;
    }

    private Collection<Drawable> getDrawableReads(Strand strand, Color color) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        TreeMap<Long, Long> collector = new TreeMap<Long, Long>();
        Chromosome lastChromosome = null;
        Iterable<ReadPart> readParts = this.readpartProvider.getReadparts(strand);
        for (ReadPart element : readParts) {
            if (!element.intersects(this.getView().getBpRegion())) continue;
            BpCoord startBp = element.start;
            BpCoord endBp = element.end;
            lastChromosome = element.start.chr;
            int seqLength = (int)(endBp.minus(startBp) + 1L);
            Long i = element.start.bp;
            while (i <= element.start.bp + (long)seqLength) {
                if (collector.containsKey(i)) {
                    collector.put(i, (Long)collector.get(i) + 1L);
                } else {
                    collector.put(i, 1L);
                }
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
            }
        }
        int bpWidth = (int)((long)this.getView().getWidth() / this.getView().getBpRegion().getLength());
        int baselineY = 0;
        Iterator bpLocations = collector.keySet().iterator();
        if (bpLocations.hasNext()) {
            Long lastBpLocation = (Long)bpLocations.next();
            int startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, lastChromosome));
            long startY = (Long)collector.get(lastBpLocation);
            drawables.add(new LineDrawable(0, baselineY, startX - bpWidth, baselineY, color));
            drawables.add(new LineDrawable(startX - bpWidth, baselineY, startX, (int)((long)baselineY + startY), color));
            while (bpLocations.hasNext()) {
                Long currentBpLocation = (Long)bpLocations.next();
                startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, lastChromosome));
                startY = (Long)collector.get(lastBpLocation);
                int endX = this.getView().bpToTrack(new BpCoord(currentBpLocation, lastChromosome));
                long endY = (Long)collector.get(currentBpLocation);
                if (currentBpLocation - lastBpLocation == 1L) {
                    drawables.add(new LineDrawable(startX, (int)((long)baselineY + startY), endX, (int)((long)baselineY + endY), color));
                } else {
                    drawables.add(new LineDrawable(startX, (int)((long)baselineY + startY), startX + bpWidth, baselineY, color));
                    drawables.add(new LineDrawable(startX + bpWidth, baselineY, endX - bpWidth, baselineY, color));
                    drawables.add(new LineDrawable(endX - bpWidth, baselineY, endX, (int)((long)baselineY + endY), color));
                }
                lastBpLocation = currentBpLocation;
            }
            int endX = this.getView().bpToTrack(new BpCoord(lastBpLocation, lastChromosome));
            long endY = (Long)collector.get(lastBpLocation);
            drawables.add(new LineDrawable(endX, (int)((long)baselineY + endY), endX + bpWidth, baselineY, color));
            drawables.add(new LineDrawable(endX + bpWidth, baselineY, this.getView().getWidth(), baselineY, color));
        }
        collector.clear();
        return drawables;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        drawables.addAll(this.getDrawableReads(Strand.FORWARD, this.forwardColor));
        drawables.addAll(this.getDrawableReads(Strand.REVERSED, this.backwardColor));
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 100;
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.SEQUENCE, ColumnType.STRAND)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public boolean canExpandDrawables() {
        return true;
    }

    @Override
    public String getName() {
        return "ProfileTrack";
    }
}

