/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.WIGParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class WIGParserTest {
    String path = "src/test/resources/wig";

    @Test
    public void testFixedStep() throws IOException {
        File wigFile = new File(this.path, "fixedStep.wig");
        WIGParser wig = new WIGParser();
        Assert.assertEquals((long)wig.getHeaderLength(new File(this.path, "fixedStep.wig")), (long)86L, (String)"incorrect header length");
        ChunkDataSource data = new ChunkDataSource(wigFile, (TsvParser)wig);
        byte[] fileChunk = new byte[(int)wigFile.length()];
        data.read(wig.getHeaderLength(wigFile), fileChunk);
        List<ColumnType> columns = Arrays.asList(ColumnType.VALUE);
        List<RegionContent> abc = data.getFileParser().getAll(new Chunk(new String(fileChunk)), columns);
        Assert.assertEquals((Object)abc.get((int)0).region.end.bp, (Object)new Long(200L));
        Assert.assertEquals((String)abc.get((int)6).values.get((Object)ColumnType.VALUE).toString(), (String)"1.1013745");
        Assert.assertEquals((Object)wig.getBpRegion((Chunk)this.getData((File)wigFile)).end.bp, (Object)new Long(3400L));
        Assert.assertEquals((Object)abc.get((int)2).region.start.bp, (Object)new Long(401L));
        Assert.assertEquals((String)abc.get((int)140).region.end.chr.toString(), (String)"21");
    }

    public Chunk getData(File file) throws IOException {
        FileReader fReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fReader);
        String string = "";
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        while (tmp != null) {
            string = string + tmp + "\n";
            tmp = reader.readLine();
        }
        return new Chunk(string);
    }

    public void testVariableStep() throws IOException {
        File wigFile = new File(this.path, "variableStep.wig");
        WIGParser wig = new WIGParser();
        Assert.assertEquals((long)wig.getHeaderLength(new File(this.path, "variableStep.wig")), (long)175L, (String)"incorrect header length");
        ChunkDataSource data = new ChunkDataSource(wigFile, (TsvParser)wig);
        byte[] fileChunk = new byte[(int)wigFile.length()];
        data.read(wig.getHeaderLength(wigFile), fileChunk);
        List<ColumnType> columns = Arrays.asList(ColumnType.VALUE);
        List<RegionContent> abc = data.getFileParser().getAll(new Chunk(new String(fileChunk)), columns);
        Assert.assertEquals((Object)abc.get((int)0).region.end.bp, (Object)new Long(830099L));
        Assert.assertEquals((String)abc.get((int)6).values.get((Object)ColumnType.VALUE).toString(), (String)"1.27");
        Assert.assertEquals((Object)wig.getBpRegion((Chunk)this.getData((File)wigFile)).end.bp, (Object)new Long(851424L));
        Assert.assertEquals((Object)abc.get((int)2).region.start.bp, (Object)new Long(830125L));
        Assert.assertEquals((String)abc.get((int)24).region.end.chr.toString(), (String)"2");
    }

    public static void main(String[] args) throws Exception {
        WIGParserTest test = new WIGParserTest();
        test.testFixedStep();
        test.testVariableStep();
    }
}

