/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.TabixReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ConcisedValueCache;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class TabixFile {
    private ConcisedValueCache cache = new ConcisedValueCache();
    private File tabixFile;

    public TabixFile(File tabixFile) {
        this.tabixFile = tabixFile;
    }

    public List<RegionContent> getReads(AreaRequest request) throws IOException {
        return TabixReader.query(this.tabixFile.getAbsolutePath(), "s", request.start.bp.toString(), request.end.bp.toString());
    }

    public List<RegionContent> getConciseReads(AreaRequest request) throws IOException {
        LinkedList<RegionContent> responseList = new LinkedList<RegionContent>();
        int SAMPLING_GRANULARITY = 40;
        int step = request.getLength().intValue() / SAMPLING_GRANULARITY;
        int SAMPLE_SIZE = 100;
        int cacheHits = 0;
        int cacheMisses = 0;
        for (long pos = request.start.bp.longValue(); pos < request.end.bp; pos += (long)step) {
            BpCoord from = new BpCoord(pos, request.start.chr);
            BpCoord to = new BpCoord(pos + (long)step, request.start.chr);
            int stepMiddlepoint = (int)pos + step / 2;
            int countForward = 0;
            Collection<ConcisedValueCache.Counts> indexedValues = this.cache.subMap(from, to).values();
            if (!indexedValues.isEmpty()) {
                ++cacheHits;
                for (ConcisedValueCache.Counts value : indexedValues) {
                    countForward += value.forwardCount.intValue();
                }
                countForward /= indexedValues.size();
            } else {
                ++cacheMisses;
                List<RegionContent> queryResult = TabixReader.query(this.tabixFile.getAbsolutePath(), "s", "" + (stepMiddlepoint - SAMPLE_SIZE / 2), "" + (stepMiddlepoint + SAMPLE_SIZE / 2));
                this.cache.store(new BpCoord(Long.valueOf(stepMiddlepoint), request.start.chr), countForward += queryResult.size(), 0);
            }
            BpCoordRegion recordRegion = new BpCoordRegion(pos, pos + (long)step, request.start.chr);
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            values.put(ColumnType.VALUE, Float.valueOf(countForward));
            values.put(ColumnType.STRAND, (Object)Strand.FORWARD);
            responseList.add(new RegionContent(recordRegion, values));
        }
        return responseList;
    }
}

