/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMFileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ConcisedValueCache;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SAMHandlerThread
extends AreaRequestHandler {
    private ConcisedValueCache cache = new ConcisedValueCache();
    private SAMDataSource samData;
    private SAMFileFetcherThread fileFetcher;
    private BlockingQueue<SAMFileRequest> fileRequestQueue = new LinkedBlockingQueue<SAMFileRequest>();
    private ConcurrentLinkedQueue<SAMFileResult> fileResultQueue = new ConcurrentLinkedQueue();

    public SAMHandlerThread(DataSource file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        super(areaRequestQueue, areaResultListener);
        this.samData = (SAMDataSource)file;
    }

    @Override
    public synchronized void run() {
        this.fileFetcher = new SAMFileFetcherThread(this.fileRequestQueue, this.fileResultQueue, this, this.samData);
        this.fileFetcher.start();
        super.run();
    }

    @Override
    protected boolean checkOtherQueues() {
        SAMFileResult fileResult = null;
        fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    private void processFileResult(SAMFileResult fileResult) {
        if (fileResult.getStatus().concise) {
            LinkedList<RegionContent> responseList = new LinkedList<RegionContent>();
            for (RegionContent content : fileResult.getContents()) {
                int countForward = (Integer)content.values.get((Object)ColumnType.VALUE_FORWARD);
                int countReverse = (Integer)content.values.get((Object)ColumnType.VALUE_REVERSE);
                this.cache.store(new BpCoord(content.region.getMid(), content.region.start.chr), countForward, countReverse);
                this.addConcisedRegionContents(fileResult.areaRequest, responseList, content.region.start.bp, content.region.end.bp, countForward, countReverse);
            }
            this.createAreaResult(new AreaResult(fileResult.getStatus(), responseList));
        } else {
            this.createAreaResult(new AreaResult(fileResult.getStatus(), fileResult.getContents()));
        }
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        if (areaRequest.status.concise) {
            this.processConcisedAreaRequest(areaRequest);
        } else {
            this.fileRequestQueue.add(new SAMFileRequest(areaRequest, areaRequest.start, areaRequest.end, areaRequest.status));
        }
    }

    public void processConcisedAreaRequest(AreaRequest request) {
        int step = request.getLength().intValue() / 100;
        for (long pos = request.start.bp.longValue(); pos < request.end.bp; pos += (long)step) {
            BpCoord to;
            BpCoord from = new BpCoord(pos, request.start.chr);
            SortedMap<BpCoord, ConcisedValueCache.Counts> indexedValues = this.cache.subMap(from, to = new BpCoord(pos + (long)step, request.start.chr));
            if (!indexedValues.isEmpty()) {
                this.convertCacheHitsToConcisedRegions(request, step, pos, indexedValues);
                continue;
            }
            this.fileRequestQueue.add(new SAMFileRequest(request, from, to, request.status));
        }
    }

    private void convertCacheHitsToConcisedRegions(AreaRequest request, int step, long pos, SortedMap<BpCoord, ConcisedValueCache.Counts> indexedValues) {
        LinkedList<RegionContent> responseList = new LinkedList<RegionContent>();
        long startPos = pos;
        int cacheHitsPerRegion = 0;
        for (BpCoord coord : indexedValues.keySet()) {
            long endPos;
            SortedMap<BpCoord, ConcisedValueCache.Counts> tailMap = indexedValues.tailMap(coord);
            if (tailMap.size() > 1) {
                Iterator<BpCoord> iterator = tailMap.keySet().iterator();
                iterator.next();
                BpCoord next = iterator.next();
                endPos = (startPos + next.bp) / 2L;
            } else {
                endPos = pos + (long)step;
            }
            this.addConcisedRegionContents(request, responseList, startPos, endPos, ((ConcisedValueCache.Counts)indexedValues.get((Object)coord)).forwardCount, ((ConcisedValueCache.Counts)indexedValues.get((Object)coord)).reverseCount);
            ++cacheHitsPerRegion;
            startPos += endPos;
        }
        this.createAreaResult(new AreaResult(request.status, responseList));
    }

    private void addConcisedRegionContents(AreaRequest request, List<RegionContent> responseList, long startPos, long endPos, int countForward, int countReverse) {
        BpCoordRegion recordRegion = new BpCoordRegion(startPos, endPos, request.start.chr);
        LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
        values.put(ColumnType.VALUE, Float.valueOf(countForward));
        values.put(ColumnType.STRAND, (Object)Strand.FORWARD);
        responseList.add(new RegionContent(recordRegion, values));
        values = new LinkedHashMap();
        values.put(ColumnType.VALUE, Float.valueOf(countReverse));
        values.put(ColumnType.STRAND, (Object)Strand.REVERSED);
        responseList.add(new RegionContent(recordRegion, values));
    }
}

