/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.CircularView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.OverviewHorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegionDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.EmptyTrack;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.UIManager;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetChangeEvent;

public class GenomePlot
extends Plot
implements ChartMouseListener,
Cloneable,
Serializable {
    private List<View> views = new LinkedList<View>();
    private View dataView = null;
    private OverviewHorizontalView overviewView = null;
    private ReadScale readScale = ReadScale.AUTO;
    public ChartPanel chartPanel;
    private boolean showFullHeight = false;
    private Rectangle dirtyArea;

    public GenomePlot(TooltipAugmentedChartPanel panel, boolean horizontal) throws FileNotFoundException, MalformedURLException {
        this.chartPanel = panel;
        this.chartPanel.setLayout(null);
        this.dirtyArea = panel.getBounds();
        this.overviewView = new OverviewHorizontalView(this);
        this.overviewView.margin = 0;
        this.overviewView.setStaticHeight(true);
        this.overviewView.setHeight(25);
        this.views.add(this.overviewView);
        if (horizontal) {
            this.dataView = new HorizontalView(this, true, true, false);
        } else {
            this.dataView = new CircularView(this, true, true, false);
            this.dataView.margin = 20;
            this.dataView.addTrack(new EmptyTrack(this.dataView, 30));
        }
        this.views.add(this.dataView);
        panel.addTooltipRequestProcessor(this.dataView);
        this.dataView.addRegionListener(new RegionListener(){

            @Override
            public void regionChanged(BpCoordRegion bpRegion) {
                ((GenomePlot)GenomePlot.this).overviewView.highlight = bpRegion;
                GenomePlot.this.overviewView.setBpRegion(new BpCoordRegionDouble(0.0, 2.5E8, bpRegion.start.chr), false);
            }
        });
        this.overviewView.addOverviewRegionListener(new RegionListener(){

            @Override
            public void regionChanged(BpCoordRegion bpRegion) {
                GenomePlot.this.dataView.setBpRegion(new BpCoordRegionDouble(bpRegion), false);
            }
        });
    }

    public View getDataView() {
        return this.dataView;
    }

    public View getOverviewView() {
        return this.overviewView;
    }

    public void start(String chromosome, Double chromosomeSizeBp, Long position, Long length) {
        this.overviewView.setBpRegion(new BpCoordRegionDouble(0.0, chromosomeSizeBp, new Chromosome(chromosome)), false);
        this.moveDataBpRegion(new Chromosome(chromosome), position, length);
    }

    public void moveDataBpRegion(Chromosome moveToChr, Long moveToBp, Long length) {
        BpCoordRegionDouble bpCoordRegion = new BpCoordRegionDouble(new Double(moveToBp - length / 2L), new Double(moveToBp + length / 2L), moveToChr);
        this.dataView.setBpRegion(bpCoordRegion, false);
    }

    public void addDataRegionListener(RegionListener regionListener) {
        this.dataView.addRegionListener(regionListener);
    }

    public String getPlotType() {
        return "GeneBrowser";
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        Rectangle viewArea;
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.setBackgroundPaint(UIManager.getColor("Panel.background"));
        g2.setClip(this.dirtyArea);
        this.drawBackground(g2, this.dirtyArea);
        Shape savedClip = g2.getClip();
        g2.clip(area);
        this.dirtyArea = viewArea = (Rectangle)area.getBounds().clone();
        for (int i = 0; i < this.views.size(); ++i) {
            View view = this.views.get(i);
            if (i > 0) {
                viewArea.y += viewArea.height;
            }
            viewArea.height = view.hasStaticHeight() ? view.getHeight() : (int)(area.getBounds().getHeight() - (double)this.sumStaticViewHeights()) / this.countStaticViews() + 1;
            g2.setClip(viewArea);
            view.drawView(g2, false);
            this.dirtyArea = viewArea.union(this.dirtyArea);
        }
        g2.setClip(savedClip);
    }

    public int getHeightTotal() {
        int total = 0;
        for (View view : this.views) {
            total += view.getTrackHeightTotal();
        }
        return total;
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public void chartMouseClicked(ChartMouseEvent e) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof GenomePlot;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void redraw() {
        this.datasetChanged(new DatasetChangeEvent((Object)this, null));
    }

    public Collection<View> getViews() {
        return this.views;
    }

    public ReadScale getReadScale() {
        return this.readScale;
    }

    public void setReadScale(ReadScale readScale) {
        this.readScale = readScale;
    }

    private int sumStaticViewHeights() {
        int heightSum = 0;
        for (View view : this.views) {
            if (!view.hasStaticHeight()) continue;
            heightSum += view.getHeight();
        }
        return heightSum;
    }

    private int countStaticViews() {
        int count = 0;
        for (View view : this.views) {
            if (!view.hasStaticHeight()) continue;
            ++count;
        }
        return count;
    }

    public boolean isFullHeight() {
        return this.showFullHeight;
    }

    public void setFullHeight(boolean b) {
        this.showFullHeight = b;
    }

    public static enum ReadScale {
        XS("0..10", 10),
        SMALL("0..50", 50),
        MEDIUM("0..100", 100),
        LARGE("0..500", 500),
        XL("0..1000", 1000),
        XXL("0..5000", 5000),
        XXXL("0..10000", 10000),
        AUTO("Automatic", 0);

        private String name;
        public Integer numReads;

        private ReadScale(String name, Integer numReads) {
            this.name = name;
            this.numReads = numReads;
        }

        public String toString() {
            return this.name;
        }
    }
}

