/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.SAMDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TooltipAugmentedChartPanel;
import fi.csc.microarray.client.visualisation.methods.gbrowser.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.SAMHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.CytobandParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.GeneParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.SequenceParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TranscriptParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.WIGParser;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class GenomeBrowserStarter {
    private static final File BAM_DATA_FILE;
    private static final File BAI_DATA_FILE;
    private static final File WIG_DATA_FILE;
    private static final File URL_ROOT;
    private static final String annotationPath;

    public static void main(String[] args) throws IOException {
        boolean horizontal = true;
        TooltipAugmentedChartPanel panel = new TooltipAugmentedChartPanel();
        GenomePlot plot = new GenomePlot(panel, horizontal);
        TrackFactory.addCytobandTracks(plot, new ChunkDataSource(URL_ROOT, "Homo_sapiens.GRCh37.59_karyotype.tsv", (TsvParser)new CytobandParser()));
        TrackFactory.addTitleTrack(plot, "SNP");
        TrackFactory.addTitleTrack(plot, "Annotations");
        TrackFactory.addGeneTracks(plot, new ChunkDataSource(URL_ROOT, "Homo_sapiens.NCBI36.54_genes.tsv", (TsvParser)new GeneParser()), new ChunkDataSource(URL_ROOT, "Homo_sapiens.NCBI36.54_transcripts.tsv", (TsvParser)new TranscriptParser()), new ChunkDataSource(URL_ROOT, "Homo_sapiens.NCBI36.54_seq.tsv", (TsvParser)new SequenceParser()), null);
        TrackFactory.addThickSeparatorTrack(plot);
        TrackFactory.addTitleTrack(plot, "WIG");
        TrackFactory.addWigTrack(plot, new ChunkDataSource(WIG_DATA_FILE, (TsvParser)new WIGParser()));
        TrackFactory.addThickSeparatorTrack(plot);
        TrackFactory.addReadTracks(plot, new SAMDataSource(BAM_DATA_FILE, BAI_DATA_FILE), SAMHandlerThread.class, new ChunkDataSource(URL_ROOT, "Homo_sapiens.NCBI36.54_seq.tsv", (TsvParser)new SequenceParser()), "Reads");
        TrackFactory.addRulerTrack(plot);
        plot.start("1", 2.62144E8, 9130000L, 100000L);
        panel.setChart(new JFreeChart((Plot)plot));
        panel.setPreferredSize(new Dimension(800, 2000));
        panel.setCursor(new Cursor(12));
        for (View view : plot.getViews()) {
            panel.addMouseListener(view);
            panel.addMouseMotionListener(view);
            panel.addMouseWheelListener(view);
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add((Component)((Object)panel));
        frame.pack();
        frame.setVisible(true);
    }

    static {
        annotationPath = System.getProperty("user.home") + "/chipster-share/";
        BAM_DATA_FILE = new File(annotationPath + "/ngs/RNA-seq/pairedEnd_Berger/501Mel.sorted.bam");
        BAI_DATA_FILE = new File(annotationPath + "/ngs/RNA-seq/pairedEnd_Berger/501Mel.sorted.bam.bai");
        URL_ROOT = new File(annotationPath, "/ngs/annotations");
        WIG_DATA_FILE = new File(annotationPath, "/ngs/wig/GSM529979_chr1.wig.out");
    }
}

