/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ChunkDataSource
extends DataSource {
    private RandomAccessFile raFile;
    private TsvParser fileParser;
    private Long length = null;

    public ChunkDataSource(URL url, TsvParser fileParser) throws FileNotFoundException {
        super(url);
        this.fileParser = fileParser;
    }

    public ChunkDataSource(File file, TsvParser fileParser) throws FileNotFoundException {
        super(file);
        this.raFile = new RandomAccessFile(file, "r");
        this.fileParser = fileParser;
    }

    public ChunkDataSource(URL urlRoot, String path, TsvParser fileParser) throws FileNotFoundException, MalformedURLException {
        super(urlRoot, path);
        this.fileParser = fileParser;
    }

    public ChunkDataSource(File fileRoot, String path, TsvParser fileParser) throws FileNotFoundException, MalformedURLException {
        this(new File(fileRoot, path), fileParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long filePosition, byte[] chunk) throws IOException {
        int n;
        if (this.raFile != null) {
            this.raFile.seek(filePosition);
            return this.raFile.read(chunk);
        }
        long endFilePosition = filePosition + (long)chunk.length;
        if (endFilePosition > this.length()) {
            endFilePosition = this.length();
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + filePosition + "-" + endFilePosition);
            int bytes = connection.getInputStream().read(chunk);
            if ((long)bytes < endFilePosition - filePosition && bytes != 0) {
                byte[] nextBytes = new byte[(int)(endFilePosition - filePosition - (long)bytes)];
                int nextLength = this.read(filePosition + (long)bytes, nextBytes);
                for (int i = 0; i < nextLength; ++i) {
                    chunk[bytes + i] = nextBytes[i];
                }
            }
            n = bytes;
        }
        catch (Throwable throwable) {
            IOUtils.disconnectIfPossible(connection);
            throw throwable;
        }
        IOUtils.disconnectIfPossible(connection);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readAll() throws IOException {
        if (this.raFile != null) {
            byte[] buf = null;
            this.raFile.seek(0L);
            buf = new byte[(int)this.raFile.length()];
            this.raFile.read(buf);
            return buf;
        }
        HttpURLConnection connection = null;
        InputStream in = null;
        ByteOutputStream out = null;
        try {
            connection = (HttpURLConnection)this.url.openConnection();
            in = connection.getInputStream();
            out = new ByteOutputStream();
            IOUtils.copy(in, (OutputStream)out);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            IOUtils.disconnectIfPossible(connection);
        }
        if (out != null) {
            return out.getBytes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws IOException {
        if (this.raFile != null) {
            return this.raFile.length();
        }
        if (this.length == null) {
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)this.url.openConnection();
                this.length = Long.parseLong(connection.getHeaderField("content-length"));
            }
            catch (Throwable throwable) {
                IOUtils.disconnectIfPossible(connection);
                throw throwable;
            }
            IOUtils.disconnectIfPossible(connection);
        }
        return this.length;
    }

    public long getHeaderLength() throws IOException {
        return this.fileParser.getHeaderLength(this.file);
    }

    public TsvParser getFileParser() {
        return this.fileParser;
    }

    public RandomAccessFile getFile() {
        return this.raFile;
    }
}

