/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.util;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.activemq.console.filter.GroupPropertiesViewFilter;
import org.apache.activemq.console.filter.MBeansAttributeQueryFilter;
import org.apache.activemq.console.filter.MBeansObjectNameQueryFilter;
import org.apache.activemq.console.filter.MBeansRegExQueryFilter;
import org.apache.activemq.console.filter.MapTransformFilter;
import org.apache.activemq.console.filter.MessagesQueryFilter;
import org.apache.activemq.console.filter.PropertiesViewFilter;
import org.apache.activemq.console.filter.QueryFilter;
import org.apache.activemq.console.filter.StubQueryFilter;
import org.apache.activemq.console.filter.WildcardToMsgSelectorTransformFilter;
import org.apache.activemq.console.filter.WildcardToRegExTransformFilter;

public final class JmxMBeansUtil {
    private JmxMBeansUtil() {
    }

    public static List getAllBrokers(MBeanServerConnection jmxConnection) throws Exception {
        return new MBeansObjectNameQueryFilter(jmxConnection).query("Type=Broker");
    }

    public static List getBrokersByName(MBeanServerConnection jmxConnection, String brokerName) throws Exception {
        return new MBeansObjectNameQueryFilter(jmxConnection).query("Type=Broker,BrokerName=" + brokerName);
    }

    public static List getAllBrokers(MBeanServerConnection jmxConnection, Set attributes) throws Exception {
        return new MBeansAttributeQueryFilter(jmxConnection, attributes, new MBeansObjectNameQueryFilter(jmxConnection)).query("Type=Broker");
    }

    public static List getBrokersByName(MBeanServerConnection jmxConnection, String brokerName, Set attributes) throws Exception {
        return new MBeansAttributeQueryFilter(jmxConnection, attributes, new MBeansObjectNameQueryFilter(jmxConnection)).query("Type=Broker,BrokerName=" + brokerName);
    }

    public static List queryMBeans(MBeanServerConnection jmxConnection, List queryList) throws Exception {
        if (queryList == null || queryList.size() == 0) {
            return JmxMBeansUtil.createMBeansObjectNameQuery(jmxConnection).query("");
        }
        return JmxMBeansUtil.createMBeansObjectNameQuery(jmxConnection).query(queryList);
    }

    public static List queryMBeans(MBeanServerConnection jmxConnection, List queryList, Set attributes) throws Exception {
        if (queryList == null || queryList.size() == 0) {
            return JmxMBeansUtil.createMBeansAttributeQuery(jmxConnection, attributes).query("");
        }
        return JmxMBeansUtil.createMBeansAttributeQuery(jmxConnection, attributes).query(queryList);
    }

    public static List queryMBeans(MBeanServerConnection jmxConnection, String queryString) throws Exception {
        return JmxMBeansUtil.createMBeansObjectNameQuery(jmxConnection).query(queryString);
    }

    public static List queryMBeans(MBeanServerConnection jmxConnection, String queryString, Set attributes) throws Exception {
        return JmxMBeansUtil.createMBeansAttributeQuery(jmxConnection, attributes).query(queryString);
    }

    public static List filterMBeansView(List mbeans, Set viewFilter) throws Exception {
        return new PropertiesViewFilter(viewFilter, new MapTransformFilter(new StubQueryFilter(mbeans))).query("");
    }

    public static String createQueryString(String query, String param) {
        return query.replaceAll("%1", param);
    }

    public static String createQueryString(String query, List params) {
        String output = query;
        int count = 1;
        Iterator i = params.iterator();
        while (i.hasNext()) {
            output = output.replaceAll("%" + count++, i.next().toString());
        }
        return output;
    }

    public static QueryFilter createMBeansObjectNameQuery(MBeanServerConnection jmxConnection) {
        return new WildcardToRegExTransformFilter(new MBeansRegExQueryFilter(new MBeansObjectNameQueryFilter(jmxConnection)));
    }

    public static QueryFilter createMBeansAttributeQuery(MBeanServerConnection jmxConnection, Set attributes) {
        return new WildcardToRegExTransformFilter(new MBeansRegExQueryFilter(new MBeansAttributeQueryFilter(jmxConnection, attributes, new MBeansObjectNameQueryFilter(jmxConnection))));
    }

    public static QueryFilter createMessageQueryFilter(MBeanServerConnection jmxConnection, ObjectName destName) {
        return new WildcardToMsgSelectorTransformFilter(new MessagesQueryFilter(jmxConnection, destName));
    }

    public static List filterMessagesView(List messages, Set groupViews, Set attributeViews) throws Exception {
        return new PropertiesViewFilter(attributeViews, new GroupPropertiesViewFilter(groupViews, new MapTransformFilter(new StubQueryFilter(messages)))).query("");
    }
}

