/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoopProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Log LOG = LogFactory.getLog(LoopProcessor.class);
    private final Expression expression;

    public LoopProcessor(Expression expression, Processor processor) {
        super(processor);
        this.expression = expression;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicInteger index = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        String text = this.expression.evaluate(exchange, String.class);
        try {
            int num = ExchangeHelper.convertToMandatoryType(exchange, Integer.class, text);
            count.set(num);
        }
        catch (NoTypeConversionAvailableException e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        exchange.setProperty("CamelLoopSize", count);
        while (index.get() < count.get()) {
            ExchangeHelper.prepareOutToIn(exchange);
            boolean sync = this.process(exchange, callback, index, count);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously"));
            }
            index.getAndIncrement();
        }
        ExchangeHelper.prepareOutToIn(exchange);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Processing complete for exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
        }
        callback.done(true);
        return true;
    }

    protected boolean process(final Exchange exchange, final AsyncCallback callback, final AtomicInteger index, final AtomicInteger count) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LoopProcessor: iteration #" + index.get()));
        }
        exchange.setProperty("CamelLoopIndex", index.get());
        boolean sync = this.processNext(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                index.getAndIncrement();
                while (index.get() < count.get()) {
                    ExchangeHelper.prepareOutToIn(exchange);
                    boolean sync = LoopProcessor.this.process(exchange, callback, index, count);
                    if (!sync) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                        }
                        return;
                    }
                    index.getAndIncrement();
                }
                ExchangeHelper.prepareOutToIn(exchange);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing complete for exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
                }
                callback.done(false);
            }
        });
        return sync;
    }

    public String toString() {
        return "Loop[for: " + this.expression + " times do: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "loop[" + this.expression + "]";
    }

    public Expression getExpression() {
        return this.expression;
    }
}

