/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ManagementStrategy;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext {
    private CamelContext context;

    public ManagedCamelContext(CamelContext context) {
        this.context = context;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Camel Version")
    public String getCamelVersion() {
        return this.context.getVersion();
    }

    @ManagedAttribute(description="Camel State")
    public String getState() {
        ServiceStatus status = ((ServiceSupport)((Object)this.context)).getStatus();
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute(description="Uptime")
    public String getUptime() {
        return this.context.getUptime();
    }

    @ManagedAttribute(description="Camel Properties")
    public Map<String, String> getProperties() {
        if (this.context.getProperties().isEmpty()) {
            return null;
        }
        return this.context.getProperties();
    }

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing() {
        return this.context.isTracing();
    }

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size();
    }

    @ManagedAttribute(description="Shutdown timeout")
    public void setTimeout(long timeout) {
        this.context.getShutdownStrategy().setTimeout(timeout);
    }

    @ManagedAttribute(description="Shutdown timeout")
    public long getTimeout() {
        return this.context.getShutdownStrategy().getTimeout();
    }

    @ManagedAttribute(description="Shutdown timeout time unit")
    public void setTimeUnit(TimeUnit timeUnit) {
        this.context.getShutdownStrategy().setTimeUnit(timeUnit);
    }

    @ManagedAttribute(description="Shutdown timeout time unit")
    public TimeUnit getTimeUnit() {
        return this.context.getShutdownStrategy().getTimeUnit();
    }

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.context.getShutdownStrategy().setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    @ManagedAttribute(description="Whether to force shutdown now when a timeout occurred")
    public boolean isShutdownNowOnTimeout() {
        return this.context.getShutdownStrategy().isShutdownNowOnTimeout();
    }

    @ManagedOperation(description="Start Camel")
    public void start() throws Exception {
        this.context.start();
    }

    @ManagedOperation(description="Stop Camel")
    public void stop() throws Exception {
        this.context.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Send body (in only)")
    public void sendBody(String endpointUri, String body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        try {
            template.sendBody(endpointUri, (Object)body);
        }
        finally {
            template.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Request body (in out)")
    public Object requestBody(String endpointUri, String body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = null;
        try {
            answer = template.requestBody(endpointUri, (Object)body);
        }
        finally {
            template.stop();
        }
        return answer;
    }
}

