/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.JettyCheckTimerTask;
import fi.csc.microarray.filebroker.JettyFileServer;
import fi.csc.microarray.manager.ManagerClient;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.FileCleanUpTimerTask;
import fi.csc.microarray.util.MemUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class FileServer
extends NodeBase
implements MessagingListener,
ShutdownCallback {
    private static Logger logger;
    private MessagingEndpoint endpoint;
    private ManagerClient managerClient;
    private AuthorisedUrlRepository urlRepository;
    private String publicDataPath;
    private String host;
    private int port;

    public static void main(String[] args) {
        DirectoryLayout.getInstance().getConfiguration();
        new FileServer(null);
    }

    public FileServer(String configURL) {
        try {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("frontend", "filebroker"), configURL);
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            logger = Logger.getLogger(FileServer.class);
            File fileRepository = DirectoryLayout.getInstance().getFileRoot();
            this.host = configuration.getString("filebroker", "url");
            this.port = configuration.getInt("filebroker", "port");
            this.urlRepository = new AuthorisedUrlRepository(this.host, this.port);
            this.publicDataPath = configuration.getString("filebroker", "public-data-path");
            JettyFileServer fileServer = new JettyFileServer(this.urlRepository);
            fileServer.start(fileRepository.getPath(), this.port);
            String userDataPath = configuration.getString("filebroker", "user-data-path");
            File userDataRoot = new File(fileRepository, userDataPath);
            int cutoff = 1000 * configuration.getInt("filebroker", "file-life-time");
            int cleanUpFrequency = 1000 * configuration.getInt("filebroker", "clean-up-frequency");
            int checkFrequency = 5000;
            Timer t = new Timer("frontend-scheduled-tasks", true);
            t.schedule((TimerTask)new FileCleanUpTimerTask(userDataRoot, cutoff), 0L, (long)cleanUpFrequency);
            t.schedule((TimerTask)new JettyCheckTimerTask(fileServer), 0L, (long)checkFrequency);
            this.endpoint = new MessagingEndpoint(this);
            MessagingTopic urlRequestTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_URL_TOPIC, MessagingTopic.AccessMode.READ);
            urlRequestTopic.setListener(this);
            this.managerClient = new ManagerClient(this.endpoint);
            KeepAliveShutdownHandler.init(this);
            logger.info((Object)("fileserver is up and running [" + ApplicationConstants.VERSION + "]"));
            logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "filebroker";
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        try {
            if (msg instanceof CommandMessage && "url-request".equals(((CommandMessage)msg).getCommand())) {
                CommandMessage requestMessage = (CommandMessage)msg;
                boolean useCompression = requestMessage.getParameters().contains("use-compression");
                URL url = this.urlRepository.createAuthorisedUrl(useCompression);
                UrlMessage reply = new UrlMessage(url);
                this.endpoint.replyToMessage(msg, (ChipsterMessage)reply);
                this.managerClient.urlRequest(msg.getUsername(), url);
            } else if (msg instanceof CommandMessage && "public-url-request".equals(((CommandMessage)msg).getCommand())) {
                URL url = this.getPublicUrL();
                UrlMessage reply = new UrlMessage(url);
                this.endpoint.replyToMessage(msg, (ChipsterMessage)reply);
                this.managerClient.publicUrlRequest(msg.getUsername(), url);
            } else {
                logger.error((Object)("message " + msg.getMessageID() + " not understood"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    public URL getPublicUrL() throws MalformedURLException {
        return new URL(this.host + ":" + this.port + "/" + this.publicDataPath);
    }
}

