/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.utils.Sequence;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SeqBlockTrack
extends Track {
    public static final Color[] charColors = new Color[]{new Color(64, 192, 64, 128), new Color(64, 64, 192, 128), new Color(128, 128, 128, 128), new Color(192, 64, 64, 128)};
    public static final Color CUTOFF_COLOR = Color.ORANGE;
    private long maxBpLength;
    private long minBpLength;
    private DataSource refData;
    private Collection<RegionContent> refReads = new TreeSet<RegionContent>();
    private boolean highlightSNP = false;
    private ReadpartDataProvider readpartProvider;

    public SeqBlockTrack(View view, DataSource file, ReadpartDataProvider readpartProvider, Class<? extends AreaRequestHandler> handler, Color fontColor, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.readpartProvider = readpartProvider;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        char[] refSeq = this.highlightSNP ? SeqBlockTrack.getReferenceArray(this.refReads, this.view, this.strand) : null;
        Iterable<ReadPart> readParts = this.readpartProvider.getReadparts(this.getStrand());
        int reads = 0;
        ArrayList<Integer> occupiedSpace = new ArrayList<Integer>();
        for (ReadPart readPart : readParts) {
            boolean lastBeforeMaxStackingDepthCut;
            int layer;
            if (!readPart.intersects(this.getView().getBpRegion())) continue;
            long widthInBps = readPart.getLength();
            Rectangle rect = new Rectangle();
            rect.x = this.getView().bpToTrack(readPart.start);
            rect.width = (int)Math.floor(this.getView().bpWidth().floatValue() * (float)widthInBps);
            if (rect.width < 2) {
                rect.width = 2;
            }
            for (layer = 0; occupiedSpace.size() > layer && (Integer)occupiedSpace.get(layer) > rect.x + 1; ++layer) {
            }
            int end = rect.x + rect.width;
            if (occupiedSpace.size() > layer) {
                occupiedSpace.set(layer, end);
            } else {
                occupiedSpace.add(end);
            }
            ++reads;
            rect.y = this.getYCoord(layer, 4);
            rect.height = 4;
            boolean bl = lastBeforeMaxStackingDepthCut = this.getYCoord(layer + 1, 4) > this.getHeight();
            if (rect.y > this.getHeight()) continue;
            String seq = readPart.getSequencePart();
            Cigar cigar = (Cigar)readPart.getRead().values.get((Object)ColumnType.CIGAR);
            if (rect.width < seq.length()) {
                Color color = Color.gray;
                if (lastBeforeMaxStackingDepthCut) {
                    color = CUTOFF_COLOR;
                }
                drawables.add(new RectDrawable(rect, color, null, cigar.toInfoString()));
                continue;
            }
            if ((Strand)((Object)readPart.getRead().values.get((Object)ColumnType.STRAND)) == Strand.REVERSED) {
                StringBuffer buf = new StringBuffer(seq.toUpperCase());
                seq = buf.toString().replace('A', 'x').replace('T', 'A').replace('x', 'T').replace('C', 'x').replace('G', 'C').replace('x', 'G');
            }
            float increment = this.getView().bpWidth().floatValue();
            float startX = this.getView().bpToTrackFloat(readPart.start).floatValue();
            for (int j = 0; j < seq.length(); ++j) {
                char letter = seq.charAt(j);
                long refIndex = j;
                Color bg = Color.white;
                long posInRef = (long)readPart.start.bp.intValue() + refIndex - (long)this.getView().getBpRegion().start.bp.intValue();
                if (this.highlightSNP && posInRef >= 0L && posInRef < (long)refSeq.length && Character.toLowerCase(refSeq[(int)posInRef]) == Character.toLowerCase(letter)) {
                    bg = Color.gray;
                } else {
                    switch (letter) {
                        case 'A': {
                            bg = charColors[0];
                            break;
                        }
                        case 'C': {
                            bg = charColors[1];
                            break;
                        }
                        case 'G': {
                            bg = charColors[2];
                            break;
                        }
                        case 'T': {
                            bg = charColors[3];
                        }
                    }
                }
                if (lastBeforeMaxStackingDepthCut) {
                    bg = CUTOFF_COLOR;
                }
                int x1 = Math.round(startX + (float)refIndex * increment);
                int x2 = Math.round(startX + ((float)refIndex + 1.0f) * increment);
                int width = Math.max(x2 - x1, 1);
                drawables.add(new RectDrawable(x1, rect.y, width, 4, bg, null, cigar.toInfoString()));
            }
        }
        return drawables;
    }

    private int getYCoord(int layer, int height) {
        return (layer + 1) * (height + 2);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        if (areaResult.getStatus().file == this.refData) {
            this.refReads.addAll(areaResult.getContents());
        }
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return super.getHeight();
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.SEQUENCE, ColumnType.STRAND, ColumnType.CIGAR)));
        if (this.highlightSNP) {
            datas.put(this.refData, new HashSet<ColumnType>(Arrays.asList(ColumnType.SEQUENCE)));
        }
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    public void enableSNPHighlight(DataSource file, Class<? extends AreaRequestHandler> handler) {
        this.highlightSNP = true;
        this.refData = file;
        this.view.getQueueManager().createQueue(file, handler);
        this.view.getQueueManager().addResultListener(file, this);
    }

    public void disableSNPHiglight(DataSource file) {
        this.highlightSNP = false;
    }

    public static char[] getReferenceArray(Collection<RegionContent> refReads, View view, Strand strand) {
        char[] refSeq = new char[]{};
        Iterator<RegionContent> iter = refReads.iterator();
        refSeq = new char[view.getBpRegion().getLength().intValue() + 1];
        int startBp = view.getBpRegion().start.bp.intValue();
        int endBp = view.getBpRegion().end.bp.intValue();
        while (iter.hasNext()) {
            RegionContent read = iter.next();
            if (!read.region.intersects(view.getBpRegion())) {
                iter.remove();
                continue;
            }
            char[] readBases = strand == Strand.REVERSED ? Sequence.complement((String)read.values.get((Object)ColumnType.SEQUENCE)).toCharArray() : ((String)read.values.get((Object)ColumnType.SEQUENCE)).toCharArray();
            int readStart = read.region.start.bp.intValue();
            int readNum = 0;
            int nextPos = 0;
            for (char c : readBases) {
                if ((nextPos = readStart + readNum++) < startBp || nextPos > endBp) continue;
                refSeq[nextPos - startBp] = c;
            }
        }
        return refSeq;
    }

    @Override
    public String getName() {
        return "Reads";
    }
}

