/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CytobandTrack
extends Track {
    private static final int THICKNESS = 11;
    private static final int MARGIN = 2;
    private BpCoord maxBp;
    private Collection<RegionContent> bands = new TreeSet<RegionContent>();
    private boolean showText;

    public Band getBand(String id) {
        for (Band band : Band.values()) {
            if (!band.getId().equals(id)) continue;
            return band;
        }
        return null;
    }

    public CytobandTrack(View view, ChunkDataSource file, Class<? extends AreaRequestHandler> handler, boolean showText) {
        super(view, file, handler);
        this.showText = showText;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.bands != null) {
            boolean firstGap = true;
            Iterator<RegionContent> bandRegionIter = this.bands.iterator();
            while (bandRegionIter.hasNext()) {
                RegionContent bandRegion = bandRegionIter.next();
                if (!this.getView().getBpRegion().intersects(bandRegion.region)) {
                    bandRegionIter.remove();
                    continue;
                }
                Band band = this.getBand((String)bandRegion.values.get((Object)ColumnType.VALUE));
                String text = (String)bandRegion.values.get((Object)ColumnType.ID);
                if (text == null) {
                    text = "";
                }
                if (band != null && band.getColor() != null) {
                    RectDrawable box = this.createDrawable(bandRegion.region.start, bandRegion.region.end, band.color);
                    drawables.add(box);
                    if (this.showText) {
                        int CHAR_WIDTH = 7;
                        int textSpace = 0;
                        textSpace = box.x >= 0 ? box.width : box.width + box.x;
                        if (textSpace > text.length() * 7) {
                            int textX = Math.max(0, box.x);
                            drawables.add(new TextDrawable(textX, box.y - 2, text, Color.black));
                        }
                    }
                    firstGap = true;
                    continue;
                }
                if (band == Band.GAP) {
                    int y = 3;
                    int sideX = this.getView().bpToTrack(bandRegion.region.end);
                    int cornerX = this.getView().bpToTrack(bandRegion.region.start);
                    if (firstGap) {
                        int tmp = sideX;
                        sideX = cornerX;
                        cornerX = tmp;
                        firstGap = false;
                    }
                    drawables.add(new LineDrawable(sideX, y, cornerX, y + 5, Color.black));
                    drawables.add(new LineDrawable(sideX, y + 11 - 1, cornerX, y + 5, Color.black));
                    continue;
                }
                if (band != Band.STALK) continue;
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(bandRegion.region.start);
                rect.width = this.getView().bpToTrack(bandRegion.region.end) - rect.x;
                rect.y = 4;
                rect.height = 6;
                drawables.add(new RectDrawable(rect, Color.gray, Color.gray));
            }
        }
        return drawables;
    }

    private RectDrawable createDrawable(BpCoord startBp, BpCoord endBp, Color c) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp) - 1;
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        rect.y = 2;
        rect.height = 11;
        return new RectDrawable(rect, c, Color.black);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent content : areaResult.getContents()) {
            if (content.values.containsKey((Object)ColumnType.METADATA) && ((Map)content.values.get((Object)ColumnType.METADATA)).containsKey("lastRowOfChromosome") && this.getView().getBpRegion().start.chr.equals(content.region.start.chr) && (this.maxBp == null || this.maxBp.compareTo(content.region.end) < 0)) {
                this.maxBp = new BpCoord(content.region.end);
            }
            if (!this.getView().getBpRegion().intersects(content.region)) continue;
            this.bands.add(content);
            this.getView().redraw();
        }
    }

    @Override
    public Integer getHeight() {
        return this.showText ? 40 : 20;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.VALUE)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public BpCoord getMaxBp(Chromosome chr) {
        return this.maxBp;
    }

    static enum Band {
        WHITE("gneg", Color.white),
        LIGHT_GRAY("gpos25", Color.lightGray),
        MOUSE_LIGHT_GRAY("gpos33", Color.lightGray),
        MID_GRAY("gpos50", Color.gray),
        MOUSE_DARK_GRAY("gpos66", Color.darkGray),
        DARK_GRAY("gpos75", Color.darkGray),
        BLACK("gpos100", Color.black),
        GAP("acen", null),
        OTHER("gvar", Color.white),
        STALK("stalk", null),
        TIP("tip", null);

        private String id;
        private Color color;

        private Band(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

