/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.CigarItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.CigarElement;

public class Cigar {
    private List<CigarItem> elements = new ArrayList<CigarItem>();
    private LinkedList<ReadPart> visibleElements = null;
    private RegionContent read;
    private net.sf.samtools.Cigar samCigar;

    public Cigar(RegionContent read, net.sf.samtools.Cigar samCigar) {
        this.read = read;
        this.samCigar = samCigar;
        for (CigarElement picardElement : samCigar.getCigarElements()) {
            this.elements.add(new CigarItem(picardElement));
        }
    }

    public void addElement(CigarItem e) {
    }

    @Deprecated
    public long getReferenceIndex(long seqIndex) {
        long seqCounter = 0L;
        long refCounter = 0L;
        for (CigarItem element : this.elements) {
            if (element.getType().equals("M")) {
                seqCounter += element.getLength();
                refCounter += element.getLength();
            } else if (element.getType().equals("S")) {
                seqCounter += element.getLength();
            } else if (element.getType().equals("D") || element.getType().equals("N") || element.getType().equals("H")) {
                refCounter += element.getLength();
            } else if (element.getType().equals("I")) {
                seqCounter += element.getLength();
            } else if (element.getType().equals("P")) {
                // empty if block
            }
            if (seqCounter <= seqIndex) continue;
            if (element.getType().equals("I")) {
                return -1L;
            }
            if (element.getType().equals("S")) {
                return -1L;
            }
            return seqIndex + refCounter - seqCounter;
        }
        return -1L;
    }

    public String toString() {
        return "Cigar";
    }

    public static List<ReadPart> splitVisibleElements(RegionContent read) {
        Cigar cigar = (Cigar)read.values.get((Object)ColumnType.CIGAR);
        if (cigar == null) {
            return Arrays.asList(new ReadPart(read));
        }
        return cigar.getVisibleElements();
    }

    private List<ReadPart> getVisibleElements() {
        if (this.visibleElements == null) {
            this.visibleElements = new LinkedList();
            long refCoord = this.read.region.start.bp;
            long seqCoord = 0L;
            String seq = (String)this.read.values.get((Object)ColumnType.SEQUENCE);
            for (CigarItem element : this.elements) {
                if (element.isVisible()) {
                    String subSeq = seq.substring((int)seqCoord, (int)(seqCoord + element.getLength()));
                    ReadPart region = new ReadPart(refCoord, refCoord + element.getLength(), this.read.region.start.chr, this.read, subSeq);
                    this.visibleElements.add(region);
                }
                if (element.consumesReferenceBases()) {
                    refCoord += element.getLength();
                }
                if (!element.consumesReadBases()) continue;
                seqCoord += element.getLength();
            }
        }
        return this.visibleElements;
    }

    public String toInfoString() {
        return "Cigar: " + this.samCigar.toString();
    }
}

