/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordRegion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class CytobandParser
extends TsvParser {
    public static final String LAST_ROW_OF_CHROMOSOME = "lastRowOfChromosome";
    public static final String TRUE = "true";

    public CytobandParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)Arrays.asList(new ColumnDefinition(ColumnType.CHROMOSOME, Type.STRING), new ColumnDefinition(ColumnType.BP_START, Type.LONG), new ColumnDefinition(ColumnType.BP_END, Type.LONG), new ColumnDefinition(ColumnType.ID, Type.STRING), new ColumnDefinition(ColumnType.VALUE, Type.STRING))));
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        return new RegionContent[0];
    }

    @Override
    public String getName() {
        return "Cytobands";
    }

    @Override
    public List<RegionContent> getAll(Chunk chunk, Collection<ColumnType> requestedContents) {
        LinkedList<RegionContent> rows = new LinkedList<RegionContent>();
        Chromosome lastChr = null;
        for (String row : chunk.getContent().split("\n")) {
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            String[] cols = row.split("\t");
            for (ColumnType requestedContent : requestedContents) {
                values.put(requestedContent, this.get(cols, requestedContent));
            }
            Long start = (Long)this.get(cols, ColumnType.BP_START);
            Long end = (Long)this.get(cols, ColumnType.BP_END);
            Chromosome chr = (Chromosome)this.get(cols, ColumnType.CHROMOSOME);
            if (lastChr != null && !lastChr.equals(chr)) {
                HashMap<String, String> metaMap = new HashMap<String, String>();
                metaMap.put(LAST_ROW_OF_CHROMOSOME, TRUE);
                ((RegionContent)rows.get((int)(rows.size() - 1))).values.put(ColumnType.METADATA, metaMap);
            }
            rows.add(new RegionContent(new BpCoordRegion(start, end, chr), values));
            lastChr = chr;
        }
        return rows;
    }
}

