/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.util.ThreadUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class VisualisationTaskManager {
    private LinkedList<Runnable> workQueue = new LinkedList();
    private Lock workQueueLock = new ReentrantLock();
    private Condition guiWorkAvailable = this.workQueueLock.newCondition();
    private ClientApplication application = Session.getSession().getApplication();
    private VisualisationFrameManager frameManager;

    public VisualisationTaskManager(VisualisationFrameManager frameManager) {
        this.frameManager = frameManager;
        Thread thread = ThreadUtils.getLowPriorityBackgroundThread(new GuiWorker());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visualise(VisualisationMethodChangedEvent e) {
        this.workQueueLock.lock();
        try {
            this.workQueue.add(new VisualisationRunnable(e));
            this.guiWorkAvailable.signalAll();
        }
        finally {
            this.workQueueLock.unlock();
        }
    }

    private class GuiWorker
    implements Runnable {
        private GuiWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Thread.currentThread().isDaemon()) {
                throw new IllegalThreadStateException("GuiWorker must be run on daemon thread");
            }
            while (true) {
                Runnable visualisationRunnable = null;
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    if (!VisualisationTaskManager.this.workQueue.isEmpty()) {
                        visualisationRunnable = (Runnable)VisualisationTaskManager.this.workQueue.getFirst();
                        VisualisationTaskManager.this.workQueue.clear();
                    }
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                }
                if (visualisationRunnable != null) {
                    visualisationRunnable.run();
                    continue;
                }
                VisualisationTaskManager.this.workQueueLock.lock();
                try {
                    VisualisationTaskManager.this.guiWorkAvailable.awaitUninterruptibly();
                    continue;
                }
                finally {
                    VisualisationTaskManager.this.workQueueLock.unlock();
                    continue;
                }
                break;
            }
        }
    }

    private class UpdateGuiRunnable
    implements Runnable {
        private JComponent visualisation;
        private VisualisationMethodChangedEvent event;

        public UpdateGuiRunnable(JComponent visualisation, VisualisationMethodChangedEvent event) {
            this.visualisation = visualisation;
            this.event = event;
        }

        @Override
        public void run() {
            VisualisationTaskManager.this.frameManager.showVisualisationComponent(this.visualisation, this.event);
        }
    }

    private class VisualisationRunnable
    implements Runnable {
        private VisualisationMethodChangedEvent event;

        public VisualisationRunnable(VisualisationMethodChangedEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            JComponent visualisation = this.event.getNewMethod() != null ? VisualisationTaskManager.this.frameManager.createVisualisation(this.event) : null;
            try {
                SwingUtilities.invokeAndWait(new UpdateGuiRunnable(visualisation, this.event));
            }
            catch (InterruptedException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
            catch (InvocationTargetException e) {
                VisualisationTaskManager.this.application.reportException(e);
            }
        }
    }
}

