/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.databeans.DataBean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class ResultBlocker
implements Operation.ResultListener {
    private CountDownLatch latch = new CountDownLatch(1);
    private Iterable<DataBean> results;
    private int enforcedResultCount;

    public ResultBlocker() {
        this(-1);
    }

    public ResultBlocker(int enforcedResultCount) {
        this.enforcedResultCount = enforcedResultCount;
    }

    @Override
    public void resultData(Iterable<DataBean> results) {
        this.results = results;
        this.latch.countDown();
    }

    @Override
    public void noResults() {
        this.results = null;
        this.latch.countDown();
    }

    public void blockUntilDone() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataBean> getResults() {
        if (this.results == null) {
            throw new IllegalStateException("no results");
        }
        Iterator<DataBean> iter = this.results.iterator();
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        while (iter.hasNext()) {
            beans.add(iter.next());
        }
        if (Session.getSession().getPrimaryModule().countOperationResults() && this.enforcedResultCount != -1 && beans.size() != this.enforcedResultCount) {
            throw new IllegalStateException("there are more or less than " + this.enforcedResultCount + " results");
        }
        return beans;
    }
}

