/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import fi.csc.microarray.client.NameID;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.session.NonStoppingValidationEventHandler;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.session.schema.DataType;
import fi.csc.microarray.client.session.schema.FolderType;
import fi.csc.microarray.client.session.schema.InputType;
import fi.csc.microarray.client.session.schema.LinkType;
import fi.csc.microarray.client.session.schema.NameType;
import fi.csc.microarray.client.session.schema.ObjectFactory;
import fi.csc.microarray.client.session.schema.OperationType;
import fi.csc.microarray.client.session.schema.ParameterType;
import fi.csc.microarray.client.session.schema.SessionType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.ZipDataBeanHandler;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.SwingTools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SessionSaver {
    private static final Logger logger = Logger.getLogger(SessionSaver.class);
    private final int DATA_BLOCK_SIZE = 2048;
    private File sessionFile;
    private HashMap<DataBean, URL> newURLs = new HashMap();
    private int entryCounter = 0;
    private int sourceCodeEntryCounter = 0;
    private int itemIdCounter = 0;
    private HashMap<String, DataItem> itemIdMap = new HashMap();
    private HashMap<DataItem, String> reversedItemIdMap = new HashMap();
    private int operationIdCounter = 0;
    private HashMap<String, OperationRecord> operationRecordIdMap = new HashMap();
    private HashMap<OperationRecord, String> reversedOperationRecordIdMap = new HashMap();
    private HashMap<String, OperationType> operationRecordTypeMap = new HashMap();
    private DataManager dataManager;
    private ObjectFactory factory;
    private SessionType sessionType;
    private String validationErrors;

    public SessionSaver(File sessionFile, DataManager dataManager) {
        this.sessionFile = sessionFile;
        this.dataManager = dataManager;
    }

    public boolean saveSession() throws Exception {
        boolean saveData = true;
        this.gatherMetadata(saveData);
        boolean metadataValid = this.validateMetadata();
        this.writeSessionFile(saveData);
        this.updateDataBeanURLsAndHandlers();
        return metadataValid;
    }

    public void saveLightweightSession() throws Exception {
        boolean saveData = false;
        this.gatherMetadata(saveData);
        this.writeSessionFile(saveData);
    }

    private void gatherMetadata(boolean saveData) throws IOException, JAXBException {
        this.factory = new ObjectFactory();
        this.sessionType = this.factory.createSessionType();
        this.sessionType.setFormatVersion(UserSession.SESSION_VERSION);
        this.generateIdsRecursively(this.dataManager.getRootFolder());
        this.saveMetadataRecursively(this.dataManager.getRootFolder(), saveData);
    }

    private boolean validateMetadata() throws JAXBException, SAXException {
        Marshaller marshaller = UserSession.getJAXBContext().createMarshaller();
        marshaller.setSchema(UserSession.getSchema());
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        NonStoppingValidationEventHandler validationEventHandler = new NonStoppingValidationEventHandler();
        marshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
        marshaller.marshal(this.factory.createSession(this.sessionType), (ContentHandler)new DefaultHandler());
        if (!validationEventHandler.hasEvents()) {
            return true;
        }
        this.validationErrors = validationEventHandler.getValidationEventsAsString();
        return false;
    }

    private void writeSessionFile(boolean saveData) throws Exception {
        File newSessionFile;
        boolean replaceOldSession = this.sessionFile.exists();
        File backupFile = null;
        if (replaceOldSession) {
            newSessionFile = new File(this.sessionFile.getAbsolutePath() + "-save-temp.zip");
            backupFile = new File(this.sessionFile.getAbsolutePath() + "-save-backup.zip");
        } else {
            newSessionFile = this.sessionFile;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(newSessionFile)));
            zipOutputStream.setLevel(1);
            ZipEntry sessionDataZipEntry = new ZipEntry("session.xml");
            zipOutputStream.putNextEntry(sessionDataZipEntry);
            Marshaller marshaller = UserSession.getJAXBContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setEventHandler((ValidationEventHandler)new NonStoppingValidationEventHandler());
            marshaller.marshal(this.factory.createSession(this.sessionType), (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
            if (saveData) {
                this.writeDataBeanContentsToZipFile(zipOutputStream);
            }
            this.writeSourceCodesToZip(zipOutputStream);
            zipOutputStream.close();
        }
        catch (Exception e) {
            IOUtils.closeIfPossible(zipOutputStream);
            newSessionFile.delete();
            throw e;
        }
        if (replaceOldSession) {
            this.dataManager.flushSession();
            if (!this.sessionFile.renameTo(backupFile)) {
                throw new IOException("Creating backup file " + backupFile.getAbsolutePath() + " failed.");
            }
            if (newSessionFile.renameTo(this.sessionFile)) {
                backupFile.delete();
            } else {
                if (backupFile.renameTo(this.sessionFile)) {
                    throw new IOException("Moving new session file " + newSessionFile + " -> " + this.sessionFile + " failed, " + "restored original session file.");
                }
                throw new IOException("Moving new session file " + newSessionFile + " -> " + this.sessionFile + " failed, " + "also restoring original file failed, backup of original is " + backupFile);
            }
        }
    }

    private void updateDataBeanURLsAndHandlers() {
        for (DataBean bean : this.newURLs.keySet()) {
            bean.setStorageMethod(DataBean.StorageMethod.LOCAL_SESSION);
            bean.setContentUrl(this.newURLs.get(bean));
            bean.setHandler(new ZipDataBeanHandler(this.dataManager));
        }
    }

    private int generateIdsRecursively(DataFolder folder) throws IOException {
        int dataCount = 0;
        this.generateId(folder);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof DataFolder) {
                int recDataCount = this.generateIdsRecursively((DataFolder)data);
                dataCount += recDataCount;
                continue;
            }
            this.generateId((DataBean)data);
            ++dataCount;
        }
        return dataCount;
    }

    private void generateId(DataItem data) {
        String id = String.valueOf(this.itemIdCounter);
        ++this.itemIdCounter;
        this.itemIdMap.put(id, data);
        this.reversedItemIdMap.put(data, id);
    }

    private String generateId(OperationRecord operationRecord) {
        String id = String.valueOf(this.operationIdCounter);
        ++this.operationIdCounter;
        this.operationRecordIdMap.put(id, operationRecord);
        this.reversedOperationRecordIdMap.put(operationRecord, id);
        return id.toString();
    }

    private void saveMetadataRecursively(DataFolder folder, boolean saveData) throws IOException {
        String folderId = this.reversedItemIdMap.get(folder);
        this.saveDataFolderMetadata(folder, folderId);
        for (DataItem data : folder.getChildren()) {
            if (data instanceof DataFolder) {
                this.saveMetadataRecursively((DataFolder)data, saveData);
                continue;
            }
            DataBean bean = (DataBean)data;
            String entryName = this.getNewZipEntryName();
            URL newURL = bean.getContentUrl();
            if (saveData) {
                newURL = new URL(this.sessionFile.toURI().toURL(), "#" + entryName);
                this.newURLs.put(bean, newURL);
            }
            this.saveDataBeanMetadata(bean, newURL, folderId, saveData);
        }
    }

    private void saveDataFolderMetadata(DataFolder folder, String folderId) {
        FolderType folderType = this.factory.createFolderType();
        folderType.setId(folderId);
        folderType.setName(folder.getName());
        if (folder.getParent() != null) {
            String parentId = this.reversedItemIdMap.get(folder.getParent());
            if (parentId != null) {
                folderType.setParent(parentId);
            } else {
                logger.warn((Object)"unknown parent");
            }
        }
        if (folder.getChildCount() > 0) {
            for (DataItem child : folder.getChildren()) {
                String childId = this.reversedItemIdMap.get(child);
                if (childId != null) {
                    folderType.getChild().add(childId);
                    continue;
                }
                logger.warn((Object)("unknown child: " + child.getName()));
            }
        }
        this.sessionType.getFolder().add(folderType);
    }

    private void saveDataBeanMetadata(DataBean bean, URL newURL, String folderId, boolean saveData) {
        String beanId = this.reversedItemIdMap.get(bean);
        DataType dataType = this.factory.createDataType();
        dataType.setId(beanId);
        dataType.setName(bean.getName());
        if (bean.getParent() != null) {
            String parentId = this.reversedItemIdMap.get(bean.getParent());
            if (parentId != null) {
                dataType.setFolder(parentId);
            } else {
                logger.warn((Object)"unknown parent");
            }
        }
        dataType.setNotes(bean.getNotes());
        if (saveData) {
            dataType.setStorageType(DataBean.StorageMethod.LOCAL_SESSION.name());
            dataType.setUrl("file:#" + newURL.getRef());
        } else {
            dataType.setStorageType(bean.getStorageMethod().toString());
            dataType.setUrl(bean.getContentUrl().toString());
        }
        if (bean.getCacheUrl() != null) {
            dataType.setCacheUrl(bean.getCacheUrl().toString());
        }
        if (bean.getOperationRecord() != null) {
            String operId;
            OperationRecord operationRecord = bean.getOperationRecord();
            if (!this.operationRecordIdMap.containsValue(operationRecord)) {
                operId = this.generateId(operationRecord);
                this.saveOperationMetadata(operationRecord, operId);
            } else {
                operId = this.reversedOperationRecordIdMap.get(operationRecord).toString();
            }
            this.operationRecordTypeMap.get(operId).getOutput().add(beanId);
            dataType.setResultOf(operId);
        }
        for (DataBean.Link type : DataBean.Link.values()) {
            for (DataBean target : bean.getLinkTargets(type)) {
                String targetId = this.reversedItemIdMap.get(target);
                if (targetId == null) continue;
                LinkType linkType = this.factory.createLinkType();
                linkType.setTarget(targetId);
                linkType.setType(type.name());
                dataType.getLink().add(linkType);
            }
        }
        this.sessionType.getData().add(dataType);
    }

    private void saveOperationMetadata(OperationRecord operationRecord, String operationId) {
        OperationType operationType = this.factory.createOperationType();
        operationType.setId(operationId);
        NameType nameType = this.createNameType(operationRecord.getNameID());
        operationType.setName(nameType);
        for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
            if (parameterRecord.getValue() == null || parameterRecord.getValue().equals("")) continue;
            ParameterType parameterType = this.factory.createParameterType();
            parameterType.setName(this.createNameType(parameterRecord.getNameID()));
            parameterType.setValue(parameterRecord.getValue());
            operationType.getParameter().add(parameterType);
        }
        for (OperationRecord.InputRecord inputRecord : operationRecord.getInputs()) {
            String inputID = this.reversedItemIdMap.get(inputRecord.getValue());
            if (inputID == null) continue;
            InputType inputType = this.factory.createInputType();
            inputType.setName(this.createNameType(inputRecord.getNameID()));
            inputType.setData(inputID);
            operationType.getInput().add(inputType);
        }
        operationType.setCategory(operationRecord.getCategoryName());
        if (operationRecord.getCategoryColor() != null) {
            operationType.setCategoryColor(SwingTools.colorToHexString(operationRecord.getCategoryColor()));
        }
        operationType.setModule(operationRecord.getModule());
        if (operationRecord.getSourceCode() != null) {
            String entryName = this.getNewSourceCodeEntryName(operationRecord.getNameID().getID());
            operationType.setSourceCodeFile(entryName);
        }
        this.sessionType.getOperation().add(operationType);
        this.operationRecordTypeMap.put(operationId, operationType);
    }

    private String getNewZipEntryName() {
        return "file-" + this.entryCounter++;
    }

    private String getNewSourceCodeEntryName(String prefix) {
        return "source-code-" + this.sourceCodeEntryCounter++ + "-" + prefix + ".txt";
    }

    private void writeDataBeanContentsToZipFile(ZipOutputStream zipOutputStream) throws IOException {
        for (Map.Entry<DataBean, URL> entry : this.newURLs.entrySet()) {
            String entryName = entry.getValue().getRef();
            this.writeFile(zipOutputStream, entryName, entry.getKey().getContentByteStream());
            zipOutputStream.closeEntry();
        }
    }

    private void writeSourceCodesToZip(ZipOutputStream zipOutputStream) throws IOException {
        for (Map.Entry<String, OperationType> entry : this.operationRecordTypeMap.entrySet()) {
            String sourceCodeFileName = entry.getValue().getSourceCodeFile();
            if (sourceCodeFileName == null || sourceCodeFileName.isEmpty()) continue;
            this.writeFile(zipOutputStream, sourceCodeFileName, new ByteArrayInputStream(this.operationRecordIdMap.get(entry.getKey()).getSourceCode().getBytes()));
        }
    }

    private void writeFile(ZipOutputStream out, String name, InputStream in) throws IOException {
        int byteCount;
        ZipEntry cpZipEntry = new ZipEntry(name);
        out.putNextEntry(cpZipEntry);
        byte[] b = new byte[2048];
        while ((byteCount = in.read(b, 0, 2048)) != -1) {
            out.write(b, 0, byteCount);
        }
        out.closeEntry();
    }

    private NameType createNameType(String id, String displayName, String desription) {
        NameType nameType = this.factory.createNameType();
        nameType.setId(id);
        nameType.setDisplayName(displayName);
        nameType.setDescription(desription);
        return nameType;
    }

    private NameType createNameType(NameID nameID) {
        return this.createNameType(nameID.getID(), nameID.getDisplayName(), nameID.getDescription());
    }

    public String getValidationErrors() {
        return this.validationErrors;
    }
}

