/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.ws;

import fi.csc.microarray.analyser.ws.ResultTableCollector;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;

public class HtmlUtil {
    public static ValueHtmlFormatter NO_FORMATTING_FORMATTER = new ValueHtmlFormatter(){

        @Override
        public String format(String value, String[] currentRow) {
            return value;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHtmlTable(ResultTableCollector annotations, String[] columnIds, String[] columnNames, ValueHtmlFormatter[] valueHtmlFormatters, String title, File output) throws FileNotFoundException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(output);
            HtmlUtil.writeHtmlTable(annotations, columnIds, columnNames, valueHtmlFormatters, title, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(out);
            throw throwable;
        }
        IOUtils.closeIfPossible(out);
    }

    public static void writeHtmlTable(ResultTableCollector annotations, String[] columnIds, String[] columnNames, ValueHtmlFormatter[] valueHtmlFormatters, String title, OutputStream outputStream) throws FileNotFoundException {
        HtmlTemplate out = new HtmlTemplate(new PrintWriter(outputStream));
        out.openDocument(title);
        out.heading(title);
        out.openTable();
        out.openRow();
        for (String columnName : columnNames) {
            out.headerCell(columnName);
        }
        out.closeRow();
        String[][] table = annotations.asTable(columnIds);
        for (int i = 0; i < table.length; ++i) {
            out.openRow();
            for (int j = 0; j < table[i].length; ++j) {
                String string = table[i][j];
                if (valueHtmlFormatters != null) {
                    string = valueHtmlFormatters[j].format(string, table[i]);
                }
                out.cell(string);
            }
            out.closeRow();
        }
        out.closeTable();
        out.closeDocument();
        out.close();
    }

    public static void writeTextTable(ResultTableCollector annotations, String[] columnIds, String[] columnNames, OutputStream outputStream) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(outputStream));
        String delimeter = "\t";
        out.print(Strings.delimit(Arrays.asList(columnNames), delimeter));
        out.print("\n");
        String[][] table = annotations.asTable(columnIds);
        for (int i = 0; i < table.length; ++i) {
            out.print(Strings.delimit(Arrays.asList(table[i]), delimeter));
            out.print("\n");
        }
        out.close();
    }

    private static class HtmlTemplate {
        final String css = "<style type=\"text/css\">\ntable {\n\tborder-width: 1px 1px 1px 1px;\n\tborder-spacing: 2px;\n\tborder-style: outset outset outset outset;\n\tborder-color: black black black black;\n\tborder-collapse: separate;\n\tbackground-color: white;\n}\ntable th {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\ntable td {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\n</style>\n";
        PrintWriter out;

        public HtmlTemplate(PrintWriter out) {
            this.out = out;
        }

        public void openDocument(String title) {
            this.out.println("<html>");
            this.out.println("<head>");
            this.out.println("<style type=\"text/css\">\ntable {\n\tborder-width: 1px 1px 1px 1px;\n\tborder-spacing: 2px;\n\tborder-style: outset outset outset outset;\n\tborder-color: black black black black;\n\tborder-collapse: separate;\n\tbackground-color: white;\n}\ntable th {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\ntable td {\n\tborder-width: 1px 1px 1px 1px;\n\tpadding: 1px 1px 1px 1px;\n\tborder-style: inset inset inset inset;\n\tborder-color: gray gray gray gray;\n\tbackground-color: white;\n\t-moz-border-radius: 0px 0px 0px 0px;\n}\n</style>\n");
            this.out.println("<title>" + title + "</title>");
            this.out.println("</head>");
        }

        public void closeDocument() {
            this.out.println("</html>");
        }

        public void close() {
            this.out.close();
        }

        public void openTable() {
            this.out.println("<table>");
        }

        public void closeTable() {
            this.out.println("</table>");
        }

        public void openRow() {
            this.out.println("<tr>");
        }

        public void closeRow() {
            this.out.println("</tr>");
        }

        public void headerCell(String name) {
            this.out.println("<th>" + name + "</th>");
        }

        public void cell(String data) {
            this.out.println("<td>" + data + "</td>");
        }

        public void heading(String heading) {
            this.out.println("<h1>" + heading + "</h1>");
        }
    }

    public static interface ValueHtmlFormatter {
        public String format(String var1, String[] var2);
    }
}

