/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolXMLGenerator {
    private File acdDir;
    private File outFile;
    private Document doc = null;
    private static final HashSet<String> ignoredGroups = new HashSet();
    private List<String> bottomGroups = new LinkedList<String>();
    private static final HashSet<String> ignoredPrograms = new HashSet();
    private LinkedHashMap<String, LinkedList<String>> groupsMap = new LinkedHashMap();
    private HashMap<String, String> colors = new HashMap();

    public ToolXMLGenerator(String acdDirPath, String outputFilePath) {
        this.acdDir = new File(acdDirPath);
        this.outFile = new File(outputFilePath);
        ignoredGroups.add("");
        ignoredGroups.add("Acd");
        ignoredGroups.add("Menus");
        ignoredGroups.add("Test");
        ignoredGroups.add("Utils");
        ignoredGroups.add("Ontology");
        ignoredGroups.add("HMM");
        this.bottomGroups.add("Enzyme Kinetics");
        this.bottomGroups.add("Feature tables");
        ignoredPrograms.add("finddb");
        ignoredPrograms.add("showdball");
        ignoredPrograms.add("seqxrefall");
        ignoredPrograms.add("showid");
        ignoredPrograms.add("idtell");
        ignoredPrograms.add("idxref");
        ignoredPrograms.add("dbquery");
        ignoredPrograms.add("prima");
        ignoredPrograms.add("primers");
        ignoredPrograms.add("newcoils");
        ignoredPrograms.add("ememe");
        ignoredPrograms.add("emast");
        ignoredPrograms.add("domtesta");
        ignoredPrograms.add("domtestb");
        ignoredPrograms.add("domtestc");
        ignoredPrograms.add("domtestd");
        ignoredPrograms.add("martattributes");
        ignoredPrograms.add("martdatasets");
        ignoredPrograms.add("martfilters");
        ignoredPrograms.add("martquery");
        ignoredPrograms.add("martregistry");
        ignoredPrograms.add("martseqs");
        ignoredPrograms.add("jaspscan");
        ignoredPrograms.add("origsplitter");
        ignoredPrograms.add("origunion");
        ignoredPrograms.add("seqretall");
        ignoredPrograms.add("seqretset");
        ignoredPrograms.add("seqrettype");
        ignoredPrograms.add("complex");
        ignoredPrograms.add("vrnapaln");
        ignoredPrograms.add("tfscan");
        ignoredPrograms.add("dbxstat");
        ignoredPrograms.add("emiraest");
        ignoredPrograms.add("ememetext");
        ignoredPrograms.add("emira");
        ignoredPrograms.add("vrnafoldpf");
        this.colors.put("alignment", "#e7881c");
        this.colors.put("alignment:multiple", "#d53833");
        this.colors.put("display", "#d5c796");
        this.colors.put("edit", "#c0d2de");
        this.colors.put("information", "#80a3b7");
        this.colors.put("nucleic", "#0177b7");
        this.colors.put("phylogeny", "#83010b");
        this.colors.put("protein", "#629a9b");
        this.colors.put("enzyme kinetics", "#629a9b");
        this.colors.put("feature tables", "#629a9b");
    }

    public void generate() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Element module = this.doc.createElement("module");
        module.setAttribute("name", "sequence");
        this.doc.appendChild(module);
        for (File acdFile : this.acdDir.listFiles()) {
            System.out.println(acdFile.getName());
            try {
                if (!acdFile.getName().endsWith(".acd")) continue;
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(acdFile));
                byte[] bytes = new byte[(int)acdFile.length()];
                inputStream.read(bytes);
                if (ignoredPrograms.contains(acdFile.getName().substring(0, acdFile.getName().indexOf(".")))) continue;
                ACDDescription acd = new ACDDescription(acdFile);
                HashSet<String> acdGroups = new HashSet<String>(this.getTopLevelGroups(acd.getGroups()));
                acdGroups.removeAll(ignoredGroups);
                LinkedList<String> acdGroupList = new LinkedList<String>();
                acdGroupList.addAll(acdGroups);
                if (acdGroups.size() <= 0) continue;
                if (!this.groupsMap.containsKey(acd.getGroups().get(0))) {
                    this.groupsMap.put(acd.getGroups().get(0), new LinkedList());
                }
                this.groupsMap.get(acd.getGroups().get(0)).add(acdFile.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList<String> sortedGroups = new LinkedList<String>(this.groupsMap.keySet());
        Collections.sort(sortedGroups);
        for (String group : this.bottomGroups) {
            if (!sortedGroups.contains(group)) continue;
            sortedGroups.remove(group);
            sortedGroups.add(group);
        }
        for (String group : sortedGroups) {
            Element category = this.doc.createElement("category");
            category.setAttribute("name", group.substring(0, 1).toUpperCase() + group.substring(1));
            String colorKey = group.trim().toLowerCase();
            if (this.colors.containsKey(colorKey)) {
                category.setAttribute("color", this.colors.get(colorKey));
            } else {
                colorKey = group.split(":")[0].trim().toLowerCase();
                if (this.colors.containsKey(colorKey)) {
                    category.setAttribute("color", this.colors.get(colorKey));
                }
            }
            module.appendChild(category);
            LinkedList<String> sortedApps = this.groupsMap.get(group);
            Collections.sort(sortedApps);
            for (String appName : sortedApps) {
                Element tool = this.doc.createElement("tool");
                Element resource = this.doc.createElement("resource");
                resource.setTextContent(appName);
                tool.setAttribute("runtime", "EMBOSS");
                tool.appendChild(resource);
                category.appendChild(tool);
            }
        }
        this.saveToFile(this.outFile);
    }

    private LinkedList<String> getTopLevelGroups(LinkedList<String> origGroupList) {
        LinkedList<String> groupList = new LinkedList<String>();
        for (String group : origGroupList) {
            groupList.add(group.split(":")[0].trim());
        }
        return groupList;
    }

    private void saveToFile(File file) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(file);
            serializer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please provide <directory for acd files> and <target xml file> as arguments.");
            return;
        }
        new ToolXMLGenerator(args[0], args[1]).generate();
    }
}

