/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class OnDiskAnalysisJobBase
extends AnalysisJob {
    private static final Logger logger = Logger.getLogger(OnDiskAnalysisJobBase.class);
    protected File jobWorkDir;

    @Override
    public void construct(JobMessage inputMessage, ToolDescription analysis, ResultCallback resultHandler) {
        super.construct(inputMessage, analysis, resultHandler);
        this.jobWorkDir = new File(resultHandler.getWorkDir(), this.getId());
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        this.cancelCheck();
        super.preExecute();
        this.updateStateDetailToClient("transferring input data");
        if (!this.jobWorkDir.mkdir()) {
            this.outputMessage.setErrorMessage("Creating working directory failed.");
            this.updateState(JobState.ERROR, "");
            return;
        }
        try {
            for (String fileName : this.inputMessage.payloadNames()) {
                this.cancelCheck();
                URL url = this.inputMessage.getPayload(fileName);
                File localFile = new File(this.jobWorkDir, fileName);
                this.resultHandler.getFileBrokerClient().getFile(new File(this.jobWorkDir, fileName), url);
                logger.debug((Object)("made available local file: " + localFile.getName() + " " + localFile.length()));
            }
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Transferring input data to computing service failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        this.updateStateDetailToClient("transferring output data");
        this.cancelCheck();
        List<ToolDescription.OutputDescription> outputFiles = this.analysis.getOutputFiles();
        for (ToolDescription.OutputDescription fileDescription : outputFiles) {
            File[] describedFiles;
            this.cancelCheck();
            if (fileDescription.getFileName().isSpliced()) {
                String prefix = fileDescription.getFileName().getPrefix();
                String postfix = fileDescription.getFileName().getPostfix();
                String regex = prefix + ".*" + postfix;
                describedFiles = Files.findFiles(this.jobWorkDir, regex);
                if (!fileDescription.isOptional() && describedFiles.length == 0) {
                    logger.error((Object)"required output file set not found");
                    this.outputMessage.setErrorMessage("Required output file set " + fileDescription.getFileName().getID() + " is missing.");
                    this.updateState(JobState.ERROR, "");
                    return;
                }
            } else {
                String outputName = fileDescription.getFileName().getID();
                describedFiles = new File[]{new File(this.jobWorkDir, outputName)};
            }
            for (File outputFile : describedFiles) {
                try {
                    URL url = this.resultHandler.getFileBrokerClient().addFile(outputFile, null);
                    this.outputMessage.addPayload(outputFile.getName(), url);
                    logger.debug((Object)("transferred output file: " + fileDescription.getFileName()));
                }
                catch (FileNotFoundException e) {
                    if (fileDescription.isOptional()) continue;
                    logger.error((Object)"required output file not found", (Throwable)e);
                    this.outputMessage.setErrorMessage("Required output file is missing.");
                    this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                    this.updateState(JobState.ERROR, "");
                    return;
                }
                catch (Exception e) {
                    logger.error((Object)"could not put file to file broker", (Throwable)e);
                    this.outputMessage.setErrorMessage("Could not send output file.");
                    this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
                    this.updateState(JobState.ERROR, "");
                    return;
                }
            }
        }
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        try {
            if (this.resultHandler.shouldSweepWorkDir()) {
                Files.delTree(this.jobWorkDir);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when cleaning up job work dir.", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }
}

