/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.tools.ngs;

import fi.csc.chipster.tools.gbrowser.ChromosomeNormaliser;
import fi.csc.chipster.tools.gbrowser.SamBamUtils;
import fi.csc.chipster.tools.gbrowser.TsvSorter;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.BEDParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ElandParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.File;
import java.io.IOException;

public class LocalNGSPreprocess
implements Runnable {
    public static final ChromosomeNormaliser CHROMOSOME_NORMALISER = new ChromosomeNormaliser(){

        @Override
        public String normaliseChromosome(String chromosomeName) {
            String SEPARATOR;
            String CHROMOSOME_NAME_PREFIX = "chr";
            if (!chromosomeName.startsWith(CHROMOSOME_NAME_PREFIX)) {
                chromosomeName = CHROMOSOME_NAME_PREFIX + chromosomeName;
            }
            if (chromosomeName.contains(SEPARATOR = ".")) {
                chromosomeName = chromosomeName.substring(0, chromosomeName.indexOf(SEPARATOR));
            }
            return chromosomeName;
        }
    };
    private static TsvParser[] parsers = new TsvParser[]{new ElandParser()};
    private Task task;

    public LocalNGSPreprocess(Task task) {
        this.task = task;
    }

    public static String getSADL() {
        StringBuffer fileFormats = new StringBuffer();
        for (int i = 0; i < parsers.length; ++i) {
            fileFormats.append(parsers[i].getName() + ": " + parsers[i].getName());
            if (i >= parsers.length - 1) continue;
            fileFormats.append(", ");
        }
        String description = "<p>Does my NGS data need to preprocessed by Chipster?</p><br/><p>-SAM files: yes</p><p>-BAM files: yes, unless your file is already sorted and you have an index file for it</p><p>-BED files: yes, unless your file is already sorted</p>";
        return "TOOL LocalNGSPreprocess.java: \"NGS Preprocess\" (" + description + ")" + "\n" + "INPUT input{...}.txt: \"Input NGS data\" TYPE GENERIC" + "\n" + "OUTPUT ngs-preprocess.txt: \"Preprocessed NGS data\"" + "\n" + "OUTPUT phenodata.tsv: \"Phenodata\"";
    }

    @Override
    public void run() {
        DataManager dataManager = Session.getSession().getDataManager();
        try {
            for (DataBean inputDataBean : this.task.getInputs()) {
                File inputFile = dataManager.getLocalFile(inputDataBean);
                String extension = inputFile.getName().substring(inputFile.getName().lastIndexOf(".") + 1);
                if ("bed".equals(extension)) {
                    this.preprocessBed(dataManager, inputFile);
                    continue;
                }
                if ("bai".equals(extension)) {
                    this.preprocessBai(dataManager, inputFile);
                    continue;
                }
                this.preprocessReads(dataManager, inputFile, extension);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateFilename(File inputFile, String extension) {
        int fileExtensionStartPosition = inputFile.getName().lastIndexOf(".");
        String outputName = fileExtensionStartPosition != -1 ? inputFile.getName().substring(0, fileExtensionStartPosition) + "-preprocessed" : inputFile.getName() + "-preprocessed";
        outputName = outputName + "." + extension;
        return outputName;
    }

    private void preprocessReads(DataManager dataManager, File inputFile, String extension) throws IOException, MicroarrayException {
        String outputName = this.generateFilename(inputFile, "bam");
        String indexOutputName = outputName + ".bai";
        File outputFile = dataManager.createNewRepositoryFile(outputName);
        File indexOutputFile = dataManager.createNewRepositoryFile(indexOutputName);
        SamBamUtils samBamUtil = new SamBamUtils(new SamBamUtils.SamBamUtilStateListener(){

            @Override
            public void stateChanged(SamBamUtils.SamBamUtilState newState) {
                LocalNGSPreprocess.this.task.setStateDetail(newState.getState() + " " + newState.getPercentage());
            }
        }, CHROMOSOME_NORMALISER);
        if (SamBamUtils.isSamBamExtension(extension)) {
            samBamUtil.preprocessSamBam(inputFile, outputFile, indexOutputFile);
        } else {
            samBamUtil.preprocessEland(inputFile, outputFile, indexOutputFile);
        }
        DataBean outputBean = dataManager.createDataBean(outputName, outputFile);
        DataBean indexOutputBean = dataManager.createDataBean(indexOutputName, indexOutputFile);
        OperationRecord operationRecord = new OperationRecord(new Operation(Session.getSession().getApplication().getOperationDefinition(this.task.getOperationID()), new DataBean[0]));
        outputBean.setOperationRecord(operationRecord);
        indexOutputBean.setOperationRecord(operationRecord);
        dataManager.getRootFolder().addChild(outputBean);
        dataManager.getRootFolder().addChild(indexOutputBean);
    }

    private void preprocessBed(DataManager dataManager, File inputFile) throws Exception {
        String outputName = this.generateFilename(inputFile, "bed");
        File outputFile = dataManager.createNewRepositoryFile(outputName);
        new TsvSorter().sort(inputFile, outputFile, new BEDParser(), CHROMOSOME_NORMALISER);
        DataBean outputBean = dataManager.createDataBean(outputName, outputFile);
        outputBean.setOperationRecord(new OperationRecord(new Operation(Session.getSession().getApplication().getOperationDefinition(this.task.getOperationID()), new DataBean[0])));
        dataManager.getRootFolder().addChild(outputBean);
    }

    private void preprocessBai(DataManager dataManager, File inputFile) throws Exception {
        String outputName = inputFile.getName();
        File outputFile = dataManager.createNewRepositoryFile(outputName);
        DataBean outputBean = dataManager.createDataBean(outputName, outputFile);
        outputBean.setOperationRecord(new OperationRecord(new Operation(Session.getSession().getApplication().getOperationDefinition(this.task.getOperationID()), new DataBean[0])));
        dataManager.getRootFolder().addChild(outputBean);
    }
}

